/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.resources;

import com.wibu.common.resources.GenericErrorGenerator;
import com.wibu.common.resources.Localizable;
import com.wibu.common.resources.LocalizationValue;
import com.wibu.common.resources.LocalizedException;
import com.wibu.common.resources.Localizer;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LocalizedMessage
implements Localizable {
    private String resourceName;
    private String bundleName;
    private Map<String, Localizable> parameters;
    private String defaultValue;

    public LocalizedMessage(LocalizationValue localizationValue, Map<String, Localizable> map) {
        this(localizationValue.getBundleName(), localizationValue.getResourceName(), localizationValue.getDefaultLocalization(), localizationValue.getRequiredParameters(), map);
    }

    private LocalizedMessage(String string, String string2, String string3, Set<String> set, Map<String, Localizable> map) {
        this.bundleName = string;
        this.resourceName = string2;
        this.defaultValue = string3;
        this.checkParameters(set, map.keySet());
        this.parameters = map;
    }

    private void checkParameters(Set<String> set, Set<String> set2) {
        TreeSet<String> treeSet = new TreeSet<String>(set);
        treeSet.removeAll(set2);
        TreeSet<String> treeSet2 = new TreeSet<String>(set2);
        treeSet2.removeAll(set);
        treeSet.addAll(treeSet2);
        if (!treeSet.isEmpty()) {
            throw new LocalizedException(GenericErrorGenerator.ParametersNotSet(((Object)treeSet).toString()));
        }
    }

    @Override
    public String getMessage(Localizer localizer) {
        String string = localizer.localize(this.bundleName, this.resourceName, this.defaultValue);
        for (Map.Entry<String, Localizable> entry : this.parameters.entrySet()) {
            String string2 = entry.getValue().getMessage(localizer);
            string = string.replace(localizer.getParamSeparator() + entry.getKey() + localizer.getParamSeparator(), string2);
        }
        return string;
    }
}

