/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.resources;

import com.wibu.common.StringUtilities;
import com.wibu.common.resources.BaseError;
import com.wibu.common.resources.Localizable;
import com.wibu.common.resources.LocalizedError;
import com.wibu.common.resources.Localizer;
import com.wibu.common.resources.ResourceLocalizer;
import com.wibu.common.resources.WrappedJavaException;
import java.util.Arrays;

public class LocalizedException
extends RuntimeException
implements Localizable {
    private final LocalizedError error;
    private final LocalizedException cause;
    private static final long serialVersionUID = -7806157207139415956L;

    public LocalizedException(LocalizedError localizedError) {
        this(null, localizedError);
    }

    public LocalizedException(Throwable throwable, LocalizedError localizedError) {
        this.cause = LocalizedException.wrapException(throwable);
        this.error = localizedError;
    }

    @Override
    public String getMessage(Localizer localizer) {
        String string = this.error.getMessage(localizer);
        if (LocalizedException.doPrintStackTrace()) {
            string = string + " (" + LocalizedException.formatStackTrace(this.getStackTrace()) + ")";
        }
        if (this.cause != null) {
            string = string + System.getProperty("line.separator") + "   caused by: ";
            if (this.cause instanceof LocalizedException) {
                string = string + this.cause.getMessage(localizer);
            }
        }
        return string;
    }

    static boolean doPrintStackTrace() {
        String string = System.getProperty("com.wibu.common.printStackTrace");
        return string != null && string.equalsIgnoreCase("true");
    }

    static String formatStackTrace(StackTraceElement[] stackTraceElementArray) {
        String string = "[ ";
        string = string + StringUtilities.concatenateWithSeparator(Arrays.asList(stackTraceElementArray), ", ");
        string = string + " ]";
        return string;
    }

    @Override
    public String getMessage() {
        return this.getMessage(new ResourceLocalizer());
    }

    public BaseError getError() {
        return this.error.getBaseError();
    }

    private static LocalizedException wrapException(Throwable throwable) {
        LocalizedException localizedException = null;
        localizedException = throwable == null ? null : (throwable instanceof LocalizedException ? (LocalizedException)throwable : new WrappedJavaException(throwable));
        return localizedException;
    }
}

