/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.resources;

import com.wibu.common.SetUtilities;
import com.wibu.common.resources.GenericErrorGenerator;
import com.wibu.common.resources.LocalizationValue;
import com.wibu.common.resources.LocalizedException;
import com.wibu.common.resources.Splitter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BaseError
implements LocalizationValue {
    private int errorValue;
    private String defaultErrorMessage;
    private Set<String> parameters;
    private String bundleName;
    private String resourceName;

    public BaseError(int n, int n2, String string, String string2, String string3, String ... stringArray) {
        this.errorValue = n + n2;
        this.defaultErrorMessage = string3;
        this.bundleName = string;
        this.resourceName = string2;
        this.parameters = BaseError.convertArrayToSet(stringArray);
        this.checkDeclaredParameters(string3, this.parameters);
    }

    private void checkDeclaredParameters(String string, Set<String> set) {
        Splitter splitter = new Splitter('%');
        Set<String> set2 = splitter.getUsedParameters(string);
        Set<String> set3 = SetUtilities.symmetricDifference(set2, set);
        if (!set3.isEmpty()) {
            throw new LocalizedException(GenericErrorGenerator.ParametersNotMatching(set3.toString(), "0x" + Integer.toHexString(this.errorValue)));
        }
    }

    private static HashSet<String> convertArrayToSet(String[] stringArray) {
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    public int getCode() {
        return this.errorValue;
    }

    @Override
    public String getBundleName() {
        return this.bundleName;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getDefaultLocalization() {
        return this.defaultErrorMessage;
    }

    @Override
    public Set<String> getRequiredParameters() {
        return this.parameters;
    }
}

