/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.jar;

import com.wibu.common.StreamConverter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

public class JarReader
implements Closeable {
    private InputStream is;
    private JarInputStream jis;
    private File file;

    public JarReader(File file) throws IOException {
        this.is = new FileInputStream(file);
        this.jis = new JarInputStream(this.is);
        this.file = file;
    }

    public JarReader(InputStream inputStream) throws IOException {
        this.is = inputStream;
        this.jis = new JarInputStream(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.jis.close();
        this.is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            zipInputStream = new JarInputStream(this.is);
            Manifest manifest = ((JarInputStream)zipInputStream).getManifest();
            return manifest;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private static boolean isManifest(String string) {
        return string.equals("META-INF/MANIFEST.MF");
    }

    public Entry getNextEntry() throws IOException {
        JarEntry jarEntry = this.jis.getNextJarEntry();
        if (null == jarEntry) {
            return null;
        }
        String string = jarEntry.getName();
        byte[] byArray = StreamConverter.readBytes(this.jis);
        if (JarReader.isManifest(string)) {
            return this.getNextEntry();
        }
        return new Entry(string, byArray);
    }

    public static class Entry {
        private final String name;
        private byte[] data;

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return this.data;
        }

        private Entry(String string, byte[] byArray) {
            this.name = string;
            this.data = byArray;
        }
    }
}

