/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

public class StreamConverter {
    private static final int minBufferSize = 1024;

    public static byte[] readBytes(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[Math.max(1024, inputStream.available())];
            int n = -1;
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readFileToString(File file, Charset charset) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            StringBuffer stringBuffer2 = stringBuffer;
            return stringBuffer2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static void writeBytes(OutputStream outputStream, byte[] byArray) throws IOException {
        outputStream.write(byArray);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void copyStream(InputStream inputStream, PrintStream printStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            printStream.write(byArray, 0, n);
        }
    }
}

