/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.HibernateException;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.tuple.AnnotationValueGeneration;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.TimestampGenerators;
import org.hibernate.tuple.ValueGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTimestampGeneration
implements AnnotationValueGeneration<UpdateTimestamp> {
    private ValueGenerator<?> generator;

    @Override
    public void initialize(UpdateTimestamp annotation, Class<?> propertyType) {
        if (java.sql.Date.class.isAssignableFrom(propertyType)) {
            this.generator = new TimestampGenerators.CurrentSqlDateGenerator();
        } else if (Time.class.isAssignableFrom(propertyType)) {
            this.generator = new TimestampGenerators.CurrentSqlTimeGenerator();
        } else if (Timestamp.class.isAssignableFrom(propertyType)) {
            this.generator = new TimestampGenerators.CurrentSqlTimestampGenerator();
        } else if (Date.class.isAssignableFrom(propertyType)) {
            this.generator = new TimestampGenerators.CurrentDateGenerator();
        } else if (Calendar.class.isAssignableFrom(propertyType)) {
            this.generator = new TimestampGenerators.CurrentCalendarGenerator();
        } else {
            throw new HibernateException("Unsupported property type for generator annotation @UpdateTimestamp");
        }
    }

    @Override
    public GenerationTiming getGenerationTiming() {
        return GenerationTiming.ALWAYS;
    }

    @Override
    public ValueGenerator<?> getValueGenerator() {
        return this.generator;
    }

    @Override
    public boolean referenceColumnInSql() {
        return false;
    }

    @Override
    public String getDatabaseGeneratedReferencedColumnValue() {
        return null;
    }
}

