/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.internal;

import java.io.Serializable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Interceptor;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.SessionFactoryBuilder;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;

public class SessionFactoryBuilderImpl
implements SessionFactoryBuilder {
    SessionFactoryOptionsImpl options;
    private final MetadataImplementor metadata;

    SessionFactoryBuilderImpl(MetadataImplementor metadata) {
        this.metadata = metadata;
        this.options = new SessionFactoryOptionsImpl(metadata.getOptions().getServiceRegistry());
    }

    public SessionFactoryBuilder with(Interceptor interceptor) {
        this.options.interceptor = interceptor;
        return this;
    }

    public SessionFactoryBuilder with(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.options.entityNotFoundDelegate = entityNotFoundDelegate;
        return this;
    }

    public SessionFactory build() {
        return new SessionFactoryImpl(this.metadata, this.options, null);
    }

    private static class SessionFactoryOptionsImpl
    implements SessionFactory.SessionFactoryOptions {
        private final StandardServiceRegistry serviceRegistry;
        private Interceptor interceptor = EmptyInterceptor.INSTANCE;
        private EntityNotFoundDelegate entityNotFoundDelegate = new EntityNotFoundDelegate(){

            public void handleEntityNotFound(String entityName, Serializable id) {
                throw new ObjectNotFoundException(id, entityName);
            }
        };

        public SessionFactoryOptionsImpl(StandardServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
        }

        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        public Interceptor getInterceptor() {
            return this.interceptor;
        }

        public EntityNotFoundDelegate getEntityNotFoundDelegate() {
            return this.entityNotFoundDelegate;
        }
    }
}

