/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.annotations.attribute.AssociationAttribute;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.attribute.SingularAttributeSourceImpl;
import org.hibernate.metamodel.source.annotations.attribute.ToOneAttributeSourceImpl;
import org.hibernate.metamodel.source.annotations.entity.EmbeddableClass;
import org.hibernate.metamodel.source.binder.AttributeSource;
import org.hibernate.metamodel.source.binder.ComponentAttributeSource;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAttributeSourceImpl
implements ComponentAttributeSource {
    private static final String PATH_SEPERATOR = ".";
    private final EmbeddableClass embeddableClass;
    private final ValueHolder<Class<?>> classReference;
    private final Map<String, AttributeOverride> attributeOverrides;
    private final String path;

    public ComponentAttributeSourceImpl(EmbeddableClass embeddableClass, String parentPath, Map<String, AttributeOverride> attributeOverrides) {
        this.embeddableClass = embeddableClass;
        this.classReference = new ValueHolder(embeddableClass.getConfiguredClass());
        this.attributeOverrides = attributeOverrides;
        this.path = StringHelper.isEmpty(parentPath) ? embeddableClass.getEmbeddedAttributeName() : parentPath + PATH_SEPERATOR + embeddableClass.getEmbeddedAttributeName();
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.COMPONENT;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public String getClassName() {
        return this.embeddableClass.getConfiguredClass().getName();
    }

    @Override
    public ValueHolder<Class<?>> getClassReference() {
        return this.classReference;
    }

    @Override
    public String getName() {
        return this.embeddableClass.getEmbeddedAttributeName();
    }

    @Override
    public String getExplicitTuplizerClassName() {
        return this.embeddableClass.getCustomTuplizer();
    }

    @Override
    public String getPropertyAccessorName() {
        return this.embeddableClass.getClassAccessType().toString().toLowerCase();
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.embeddableClass.getLocalBindingContext();
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> attributeList = new ArrayList<AttributeSource>();
        for (BasicAttribute attribute : this.embeddableClass.getSimpleAttributes()) {
            AttributeOverride attributeOverride = null;
            String tmp = this.getPath() + PATH_SEPERATOR + attribute.getName();
            if (this.attributeOverrides.containsKey(tmp)) {
                attributeOverride = this.attributeOverrides.get(tmp);
            }
            attributeList.add(new SingularAttributeSourceImpl(attribute, attributeOverride));
        }
        for (EmbeddableClass embeddable : this.embeddableClass.getEmbeddedClasses().values()) {
            attributeList.add(new ComponentAttributeSourceImpl(embeddable, this.getPath(), this.createAggregatedOverrideMap()));
        }
        for (AssociationAttribute associationAttribute : this.embeddableClass.getAssociationAttributes()) {
            attributeList.add(new ToOneAttributeSourceImpl(associationAttribute));
        }
        return attributeList;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getParentReferenceAttributeName() {
        return this.embeddableClass.getParentReferencingAttributeName();
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Collections.emptySet();
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return null;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return null;
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public PropertyGeneration getGeneration() {
        return null;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return true;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return true;
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return true;
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ComponentAttributeSourceImpl");
        sb.append("{embeddableClass=").append(this.embeddableClass.getConfiguredClass().getSimpleName());
        sb.append('}');
        return sb.toString();
    }

    private Map<String, AttributeOverride> createAggregatedOverrideMap() {
        HashMap<String, AttributeOverride> aggregatedOverrideMap = new HashMap<String, AttributeOverride>(this.attributeOverrides);
        for (Map.Entry<String, AttributeOverride> entry : this.embeddableClass.getAttributeOverrideMap().entrySet()) {
            String fullPath = this.getPath() + PATH_SEPERATOR + entry.getKey();
            if (aggregatedOverrideMap.containsKey(fullPath)) continue;
            aggregatedOverrideMap.put(fullPath, entry.getValue());
        }
        return aggregatedOverrideMap;
    }
}

