/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolver;
import org.hibernate.metamodel.source.annotations.attribute.type.AttributeTypeResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeAttributeTypeResolver
implements AttributeTypeResolver {
    private List<AttributeTypeResolver> resolvers = new ArrayList<AttributeTypeResolver>();
    private final AttributeTypeResolverImpl explicitHibernateTypeResolver;

    public CompositeAttributeTypeResolver(AttributeTypeResolverImpl explicitHibernateTypeResolver) {
        if (explicitHibernateTypeResolver == null) {
            throw new AssertionFailure("The Given AttributeTypeResolver is null.");
        }
        this.explicitHibernateTypeResolver = explicitHibernateTypeResolver;
    }

    public void addHibernateTypeResolver(AttributeTypeResolver resolver) {
        if (resolver == null) {
            throw new AssertionFailure("The Given AttributeTypeResolver is null.");
        }
        this.resolvers.add(resolver);
    }

    @Override
    public String getExplicitHibernateTypeName() {
        String type;
        block1: {
            AttributeTypeResolver resolver;
            type = this.explicitHibernateTypeResolver.getExplicitHibernateTypeName();
            if (!StringHelper.isEmpty(type)) break block1;
            Iterator<AttributeTypeResolver> iterator = this.resolvers.iterator();
            while (iterator.hasNext() && !StringHelper.isNotEmpty(type = (resolver = iterator.next()).getExplicitHibernateTypeName())) {
            }
        }
        return type;
    }

    @Override
    public Map<String, String> getExplicitHibernateTypeParameters() {
        Map<String, String> parameters;
        block1: {
            AttributeTypeResolver resolver;
            parameters = this.explicitHibernateTypeResolver.getExplicitHibernateTypeParameters();
            if (!CollectionHelper.isEmpty(parameters)) break block1;
            Iterator<AttributeTypeResolver> iterator = this.resolvers.iterator();
            while (iterator.hasNext() && !CollectionHelper.isNotEmpty(parameters = (resolver = iterator.next()).getExplicitHibernateTypeParameters())) {
            }
        }
        return parameters;
    }
}

