/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AccessType;
import javax.persistence.InheritanceType;
import org.hibernate.AnnotationException;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.EntityHierarchyImpl;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.entity.EntityClass;
import org.hibernate.metamodel.source.annotations.entity.RootEntitySourceImpl;
import org.hibernate.metamodel.source.annotations.entity.SubclassEntitySourceImpl;
import org.hibernate.metamodel.source.binder.EntityHierarchy;
import org.hibernate.metamodel.source.binder.EntitySource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityHierarchyBuilder {
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());

    public static Set<EntityHierarchy> createEntityHierarchies(AnnotationBindingContext bindingContext) {
        HashSet<EntityHierarchy> hierarchies = new HashSet<EntityHierarchy>();
        ArrayList<DotName> processedEntities = new ArrayList<DotName>();
        HashMap<DotName, List<ClassInfo>> classToDirectSubClassMap = new HashMap<DotName, List<ClassInfo>>();
        Index index = bindingContext.getIndex();
        for (ClassInfo info : index.getKnownClasses()) {
            if (!EntityHierarchyBuilder.isEntityClass(info) || processedEntities.contains(info.name())) continue;
            ClassInfo rootClassInfo = EntityHierarchyBuilder.findRootEntityClassInfo(index, info);
            ArrayList<ClassInfo> rootClassWithAllSubclasses = new ArrayList<ClassInfo>();
            EntityHierarchyBuilder.addMappedSuperclasses(index, rootClassInfo, rootClassWithAllSubclasses);
            EntityHierarchyBuilder.processHierarchy(bindingContext, rootClassInfo, rootClassWithAllSubclasses, processedEntities, classToDirectSubClassMap);
            AccessType defaultAccessType = EntityHierarchyBuilder.determineDefaultAccessType(rootClassWithAllSubclasses);
            org.hibernate.metamodel.binding.InheritanceType hierarchyInheritanceType = EntityHierarchyBuilder.determineInheritanceType(rootClassInfo, rootClassWithAllSubclasses);
            EntityClass rootEntityClass = new EntityClass(rootClassInfo, null, defaultAccessType, hierarchyInheritanceType, bindingContext);
            RootEntitySourceImpl rootSource = new RootEntitySourceImpl(rootEntityClass);
            EntityHierarchyBuilder.addSubclassEntitySources(bindingContext, classToDirectSubClassMap, defaultAccessType, hierarchyInheritanceType, rootEntityClass, rootSource);
            hierarchies.add(new EntityHierarchyImpl(rootSource, hierarchyInheritanceType));
        }
        return hierarchies;
    }

    private static void addSubclassEntitySources(AnnotationBindingContext bindingContext, Map<DotName, List<ClassInfo>> classToDirectSubClassMap, AccessType defaultAccessType, org.hibernate.metamodel.binding.InheritanceType hierarchyInheritanceType, EntityClass entityClass, EntitySource entitySource) {
        List<ClassInfo> subClassInfoList = classToDirectSubClassMap.get(DotName.createSimple((String)entitySource.getClassName()));
        if (subClassInfoList == null) {
            return;
        }
        for (ClassInfo subClassInfo : subClassInfoList) {
            EntityClass subclassEntityClass = new EntityClass(subClassInfo, entityClass, defaultAccessType, hierarchyInheritanceType, bindingContext);
            SubclassEntitySourceImpl subclassEntitySource = new SubclassEntitySourceImpl(subclassEntityClass);
            entitySource.add(subclassEntitySource);
            EntityHierarchyBuilder.addSubclassEntitySources(bindingContext, classToDirectSubClassMap, defaultAccessType, hierarchyInheritanceType, subclassEntityClass, subclassEntitySource);
        }
    }

    private static ClassInfo findRootEntityClassInfo(Index index, ClassInfo info) {
        ClassInfo rootEntity = info;
        DotName superName = info.superName();
        while (!OBJECT.equals((Object)superName)) {
            ClassInfo tmpInfo = index.getClassByName(superName);
            if (EntityHierarchyBuilder.isEntityClass(tmpInfo)) {
                rootEntity = tmpInfo;
            }
            superName = tmpInfo.superName();
        }
        return rootEntity;
    }

    private static void addMappedSuperclasses(Index index, ClassInfo info, List<ClassInfo> classInfoList) {
        DotName superName = info.superName();
        while (!OBJECT.equals((Object)superName)) {
            ClassInfo tmpInfo = index.getClassByName(superName);
            if (EntityHierarchyBuilder.isMappedSuperclass(tmpInfo)) {
                classInfoList.add(tmpInfo);
            }
            superName = tmpInfo.superName();
        }
    }

    private static void processHierarchy(AnnotationBindingContext bindingContext, ClassInfo classInfo, List<ClassInfo> rootClassWithAllSubclasses, List<DotName> processedEntities, Map<DotName, List<ClassInfo>> classToDirectSubclassMap) {
        processedEntities.add(classInfo.name());
        rootClassWithAllSubclasses.add(classInfo);
        List subClasses = bindingContext.getIndex().getKnownDirectSubclasses(classInfo.name());
        if (subClasses.isEmpty()) {
            bindingContext.resolveAllTypes(classInfo.name().toString());
        }
        for (ClassInfo subClassInfo : subClasses) {
            EntityHierarchyBuilder.addSubClassToSubclassMap(classInfo.name(), subClassInfo, classToDirectSubclassMap);
            EntityHierarchyBuilder.processHierarchy(bindingContext, subClassInfo, rootClassWithAllSubclasses, processedEntities, classToDirectSubclassMap);
        }
    }

    private static void addSubClassToSubclassMap(DotName name, ClassInfo subClassInfo, Map<DotName, List<ClassInfo>> classToDirectSubclassMap) {
        if (classToDirectSubclassMap.containsKey(name)) {
            classToDirectSubclassMap.get(name).add(subClassInfo);
        } else {
            ArrayList<ClassInfo> subclassList = new ArrayList<ClassInfo>();
            subclassList.add(subClassInfo);
            classToDirectSubclassMap.put(name, subclassList);
        }
    }

    private static boolean isEntityClass(ClassInfo info) {
        if (info == null) {
            return false;
        }
        AnnotationInstance jpaEntityAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.ENTITY);
        if (jpaEntityAnnotation == null) {
            return false;
        }
        AnnotationInstance mappedSuperClassAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.MAPPED_SUPERCLASS);
        String className = info.toString();
        EntityHierarchyBuilder.assertNotEntityAndMappedSuperClass(jpaEntityAnnotation, mappedSuperClassAnnotation, className);
        AnnotationInstance embeddableAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.EMBEDDABLE);
        EntityHierarchyBuilder.assertNotEntityAndEmbeddable(jpaEntityAnnotation, embeddableAnnotation, className);
        return true;
    }

    private static boolean isMappedSuperclass(ClassInfo info) {
        if (info == null) {
            return false;
        }
        AnnotationInstance mappedSuperclassAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.MAPPED_SUPERCLASS);
        return mappedSuperclassAnnotation != null;
    }

    private static void assertNotEntityAndMappedSuperClass(AnnotationInstance jpaEntityAnnotation, AnnotationInstance mappedSuperClassAnnotation, String className) {
        if (jpaEntityAnnotation != null && mappedSuperClassAnnotation != null) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @MappedSuperclass. " + className + " has both annotations.");
        }
    }

    private static void assertNotEntityAndEmbeddable(AnnotationInstance jpaEntityAnnotation, AnnotationInstance embeddableAnnotation, String className) {
        if (jpaEntityAnnotation != null && embeddableAnnotation != null) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @Embeddable. " + className + " has both annotations.");
        }
    }

    private static AccessType determineDefaultAccessType(List<ClassInfo> classes) {
        AccessType accessTypeByEmbeddedIdPlacement = null;
        AccessType accessTypeByIdPlacement = null;
        for (ClassInfo info : classes) {
            List idAnnotations = (List)info.annotations().get(JPADotNames.ID);
            List embeddedIdAnnotations = (List)info.annotations().get(JPADotNames.EMBEDDED_ID);
            if (CollectionHelper.isNotEmpty(embeddedIdAnnotations)) {
                accessTypeByEmbeddedIdPlacement = EntityHierarchyBuilder.determineAccessTypeByIdPlacement(embeddedIdAnnotations);
            }
            if (!CollectionHelper.isNotEmpty(idAnnotations)) continue;
            accessTypeByIdPlacement = EntityHierarchyBuilder.determineAccessTypeByIdPlacement(idAnnotations);
        }
        if (accessTypeByEmbeddedIdPlacement != null) {
            return accessTypeByEmbeddedIdPlacement;
        }
        if (accessTypeByIdPlacement != null) {
            return accessTypeByIdPlacement;
        }
        return EntityHierarchyBuilder.throwIdNotFoundAnnotationException(classes);
    }

    private static AccessType determineAccessTypeByIdPlacement(List<AnnotationInstance> idAnnotations) {
        AccessType accessType = null;
        for (AnnotationInstance annotation : idAnnotations) {
            AccessType tmpAccessType;
            if (annotation.target() instanceof FieldInfo) {
                tmpAccessType = AccessType.FIELD;
            } else if (annotation.target() instanceof MethodInfo) {
                tmpAccessType = AccessType.PROPERTY;
            } else {
                throw new AnnotationException("Invalid placement of @Id annotation");
            }
            if (accessType == null) {
                accessType = tmpAccessType;
                continue;
            }
            if (accessType.equals((Object)tmpAccessType)) continue;
            throw new AnnotationException("Inconsistent placement of @Id annotation within hierarchy ");
        }
        return accessType;
    }

    private static org.hibernate.metamodel.binding.InheritanceType determineInheritanceType(ClassInfo rootClassInfo, List<ClassInfo> classes) {
        if (classes.size() == 1) {
            return org.hibernate.metamodel.binding.InheritanceType.NO_INHERITANCE;
        }
        org.hibernate.metamodel.binding.InheritanceType inheritanceType = org.hibernate.metamodel.binding.InheritanceType.SINGLE_TABLE;
        AnnotationInstance inheritanceAnnotation = JandexHelper.getSingleAnnotation(rootClassInfo, JPADotNames.INHERITANCE);
        if (inheritanceAnnotation != null) {
            String enumName = inheritanceAnnotation.value("strategy").asEnum();
            InheritanceType jpaInheritanceType = Enum.valueOf(InheritanceType.class, enumName);
            inheritanceType = org.hibernate.metamodel.binding.InheritanceType.get(jpaInheritanceType);
        }
        for (ClassInfo info : classes) {
            if (rootClassInfo.equals(info) || (inheritanceAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.INHERITANCE)) == null) continue;
            throw new AnnotationException(String.format("The inheritance type for %s must be specified on the root entity %s", EntityHierarchyBuilder.hierarchyListString(classes), rootClassInfo.name().toString()));
        }
        return inheritanceType;
    }

    private static AccessType throwIdNotFoundAnnotationException(List<ClassInfo> classes) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unable to determine identifier attribute for class hierarchy consisting of the classe(s) ");
        builder.append(EntityHierarchyBuilder.hierarchyListString(classes));
        throw new AnnotationException(builder.toString());
    }

    private static String hierarchyListString(List<ClassInfo> classes) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int count = 0;
        for (ClassInfo info : classes) {
            builder.append(info.name().toString());
            if (count < classes.size() - 1) {
                builder.append(", ");
            }
            ++count;
        }
        builder.append("]");
        return builder.toString();
    }
}

