/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.TableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
extends AbstractConstraint
implements Constraint {
    protected Index(Table table, String name) {
        super(table, name);
    }

    @Override
    public String getExportIdentifier() {
        StringBuilder sb = new StringBuilder(this.getTable().getLoggableValueQualifier());
        sb.append(".IDX");
        for (Column column : this.getColumns()) {
            sb.append('_').append(column.getColumnName().getName());
        }
        return sb.toString();
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) {
        return new String[]{Index.buildSqlCreateIndexString(dialect, this.getName(), this.getTable(), this.getColumns(), false)};
    }

    public static String buildSqlCreateIndexString(Dialect dialect, String name, TableSpecification table, Iterable<Column> columns, boolean unique) {
        StringBuilder buf = new StringBuilder("create").append(unique ? " unique" : "").append(" index ").append(dialect.qualifyIndexName() ? name : StringHelper.unqualify(name)).append(" on ").append(table.getQualifiedName(dialect)).append(" (");
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        buf.append(")");
        return buf.toString();
    }

    public static String buildSqlDropIndexString(Dialect dialect, TableSpecification table, String name) {
        return "drop index " + StringHelper.qualify(table.getQualifiedName(dialect), name);
    }

    @Override
    public String sqlConstraintStringInAlterTable(Dialect dialect) {
        StringBuilder buf = new StringBuilder(" index (");
        boolean first = true;
        for (Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(column.getColumnName().encloseInQuotesIfQuoted(dialect));
        }
        return buf.append(')').toString();
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) {
        return new String[]{"drop index " + StringHelper.qualify(this.getTable().getQualifiedName(dialect), this.getName())};
    }
}

