/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.binding;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.AbstractSingularAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.hibernate.metamodel.binding.BagBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.CollectionElementNature;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.Helper;
import org.hibernate.metamodel.binding.ManyToOneAttributeBinding;
import org.hibernate.metamodel.binding.SetBinding;
import org.hibernate.metamodel.domain.AttributeContainer;
import org.hibernate.metamodel.domain.Component;
import org.hibernate.metamodel.domain.PluralAttribute;
import org.hibernate.metamodel.domain.PluralAttributeNature;
import org.hibernate.metamodel.domain.SingularAttribute;
import org.hibernate.metamodel.source.MetaAttributeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentAttributeBinding
extends AbstractSingularAttributeBinding
implements AttributeBindingContainer {
    private final String path;
    private Map<String, AttributeBinding> attributeBindingMap = new HashMap<String, AttributeBinding>();
    private SingularAttribute parentReference;
    private MetaAttributeContext metaAttributeContext;

    public ComponentAttributeBinding(AttributeBindingContainer container, SingularAttribute attribute) {
        super(container, attribute);
        this.path = container.getPathBase() + '.' + attribute.getName();
    }

    @Override
    public EntityBinding seekEntityBinding() {
        return this.getContainer().seekEntityBinding();
    }

    @Override
    public String getPathBase() {
        return this.path;
    }

    @Override
    public AttributeContainer getAttributeContainer() {
        return this.getComponent();
    }

    public Component getComponent() {
        return (Component)this.getAttribute().getSingularAttributeType();
    }

    @Override
    public boolean isAssociation() {
        return false;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    @Override
    public void setMetaAttributeContext(MetaAttributeContext metaAttributeContext) {
        this.metaAttributeContext = metaAttributeContext;
    }

    @Override
    public AttributeBinding locateAttributeBinding(String name) {
        return this.attributeBindingMap.get(name);
    }

    @Override
    public Iterable<AttributeBinding> attributeBindings() {
        return this.attributeBindingMap.values();
    }

    @Override
    protected void checkValueBinding() {
    }

    @Override
    public BasicAttributeBinding makeBasicAttributeBinding(SingularAttribute attribute) {
        BasicAttributeBinding binding = new BasicAttributeBinding(this, attribute, this.isNullable(), this.isAlternateUniqueKey());
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    protected void registerAttributeBinding(String name, AttributeBinding attributeBinding) {
        this.attributeBindingMap.put(name, attributeBinding);
    }

    @Override
    public ComponentAttributeBinding makeComponentAttributeBinding(SingularAttribute attribute) {
        ComponentAttributeBinding binding = new ComponentAttributeBinding((AttributeBindingContainer)this, attribute);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public ManyToOneAttributeBinding makeManyToOneAttributeBinding(SingularAttribute attribute) {
        ManyToOneAttributeBinding binding = new ManyToOneAttributeBinding((AttributeBindingContainer)this, attribute);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public BagBinding makeBagAttributeBinding(PluralAttribute attribute, CollectionElementNature nature) {
        Helper.checkPluralAttributeNature(attribute, PluralAttributeNature.BAG);
        BagBinding binding = new BagBinding(this, attribute, nature);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public SetBinding makeSetAttributeBinding(PluralAttribute attribute, CollectionElementNature nature) {
        Helper.checkPluralAttributeNature(attribute, PluralAttributeNature.SET);
        SetBinding binding = new SetBinding(this, attribute, nature);
        this.registerAttributeBinding(attribute.getName(), binding);
        return binding;
    }

    @Override
    public Class<?> getClassReference() {
        return this.getComponent().getClassReference();
    }

    public SingularAttribute getParentReference() {
        return this.parentReference;
    }

    public void setParentReference(SingularAttribute parentReference) {
        this.parentReference = parentReference;
    }

    @Override
    public PropertyGeneration getGeneration() {
        return null;
    }
}

