/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.HolderInstantiator;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;

public class ScrollableResultsImpl
extends AbstractScrollableResults
implements ScrollableResults {
    private Object[] currentRow;

    public ScrollableResultsImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Loader loader, QueryParameters queryParameters, Type[] types, HolderInstantiator holderInstantiator) {
        super(rs, ps, sess, loader, queryParameters, types, holderInstantiator);
    }

    protected Object[] getCurrentRow() {
        return this.currentRow;
    }

    public boolean scroll(int i) {
        try {
            boolean result = this.getResultSet().relative(i);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using scroll()");
        }
    }

    public boolean first() {
        try {
            boolean result = this.getResultSet().first();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using first()");
        }
    }

    public boolean last() {
        try {
            boolean result = this.getResultSet().last();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using last()");
        }
    }

    public boolean next() {
        try {
            boolean result = this.getResultSet().next();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using next()");
        }
    }

    public boolean previous() {
        try {
            boolean result = this.getResultSet().previous();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using previous()");
        }
    }

    public void afterLast() {
        try {
            this.getResultSet().afterLast();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling afterLast()");
        }
    }

    public void beforeFirst() {
        try {
            this.getResultSet().beforeFirst();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling beforeFirst()");
        }
    }

    public boolean isFirst() {
        try {
            return this.getResultSet().isFirst();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling isFirst()");
        }
    }

    public boolean isLast() {
        try {
            return this.getResultSet().isLast();
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling isLast()");
        }
    }

    public int getRowNumber() throws HibernateException {
        try {
            return this.getResultSet().getRow() - 1;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "exception calling getRow()");
        }
    }

    public boolean setRowNumber(int rowNumber) throws HibernateException {
        if (rowNumber >= 0) {
            ++rowNumber;
        }
        try {
            boolean result = this.getResultSet().absolute(rowNumber);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(sqle, "could not advance using absolute()");
        }
    }

    private void prepareCurrentRow(boolean underlyingScrollSuccessful) {
        if (!underlyingScrollSuccessful) {
            this.currentRow = null;
            return;
        }
        Object result = this.getLoader().loadSingleRow(this.getResultSet(), this.getSession(), this.getQueryParameters(), false);
        this.currentRow = result != null && result.getClass().isArray() ? (Object[])result : new Object[]{result};
        if (this.getHolderInstantiator() != null) {
            this.currentRow = new Object[]{this.getHolderInstantiator().instantiate(this.currentRow)};
        }
        this.afterScrollOperation();
    }
}

