/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.event.internal.AbstractVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private boolean dirty;
    private boolean[] propertyVersionability;

    DirtyCollectionSearchVisitor(EventSource session, boolean[] propertyVersionability) {
        super(session);
        this.propertyVersionability = propertyVersionability;
    }

    boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            EventSource session = this.getSession();
            PersistentCollection persistentCollection = type.isArrayType() ? session.getPersistenceContext().getCollectionHolder(collection) : (PersistentCollection)collection;
            if (persistentCollection.isDirty()) {
                this.dirty = true;
                return null;
            }
        }
        return null;
    }

    boolean includeEntityProperty(Object[] values, int i) {
        return this.propertyVersionability[i] && super.includeEntityProperty(values, i);
    }
}

