/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal.jta;

import javax.transaction.SystemException;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.CMTTransaction;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMTTransactionFactory
implements TransactionFactory<CMTTransaction> {
    public static final String SHORT_NAME = "cmt";

    @Override
    public CMTTransaction createTransaction(TransactionCoordinator transactionCoordinator) {
        return new CMTTransaction(transactionCoordinator);
    }

    @Override
    public boolean canBeDriver() {
        return false;
    }

    @Override
    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    @Override
    public boolean compatibleWithJtaSynchronization() {
        return true;
    }

    @Override
    public boolean isJoinableJtaTransaction(TransactionCoordinator transactionCoordinator, CMTTransaction transaction) {
        try {
            int status = transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform().getCurrentStatus();
            return JtaStatusHelper.isActive(status);
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", se);
        }
    }
}

