/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.UnsavedValueStrategy;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.jboss.logging.Logger;

public class VersionValue
implements UnsavedValueStrategy {
    private static final Logger LOG = CoreLogging.logger(VersionValue.class);
    private final Object value;
    public static final VersionValue NULL = new VersionValue(){

        public final Boolean isUnsaved(Object version) {
            LOG.trace((Object)"Version unsaved-value strategy NULL");
            return version == null;
        }

        public Object getDefaultValue(Object currentValue) {
            return null;
        }

        public String toString() {
            return "VERSION_SAVE_NULL";
        }
    };
    public static final VersionValue UNDEFINED = new VersionValue(){

        public final Boolean isUnsaved(Object version) {
            LOG.trace((Object)"Version unsaved-value strategy UNDEFINED");
            return version == null ? Boolean.TRUE : null;
        }

        public Object getDefaultValue(Object currentValue) {
            return currentValue;
        }

        public String toString() {
            return "VERSION_UNDEFINED";
        }
    };
    public static final VersionValue NEGATIVE = new VersionValue(){

        public final Boolean isUnsaved(Object version) throws MappingException {
            LOG.trace((Object)"Version unsaved-value strategy NEGATIVE");
            if (version == null) {
                return Boolean.TRUE;
            }
            if (version instanceof Number) {
                return ((Number)version).longValue() < 0L;
            }
            throw new MappingException("unsaved-value NEGATIVE may only be used with short, int and long types");
        }

        public Object getDefaultValue(Object currentValue) {
            return IdentifierGeneratorHelper.getIntegralDataTypeHolder(currentValue.getClass()).initialize(-1L).makeValue();
        }

        public String toString() {
            return "VERSION_NEGATIVE";
        }
    };

    protected VersionValue() {
        this.value = null;
    }

    public VersionValue(Object value) {
        this.value = value;
    }

    public Boolean isUnsaved(Object version) throws MappingException {
        LOG.tracev("Version unsaved-value: {0}", this.value);
        return version == null || version.equals(this.value);
    }

    public Object getDefaultValue(Object currentValue) {
        return this.value;
    }

    public String toString() {
        return "version unsaved-value: " + this.value;
    }
}

