/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.ResultSetReturn;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetReturnImpl
implements ResultSetReturn {
    private final JdbcCoordinator jdbcCoordinator;
    private final Dialect dialect;
    private final SqlStatementLogger sqlStatementLogger;
    private final SqlExceptionHelper sqlExceptionHelper;
    private boolean isJdbc4 = true;

    public ResultSetReturnImpl(JdbcCoordinator jdbcCoordinator) {
        this.jdbcCoordinator = jdbcCoordinator;
        JdbcServices jdbcServices = jdbcCoordinator.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJdbcServices();
        this.dialect = jdbcServices.getDialect();
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.sqlExceptionHelper = jdbcServices.getSqlExceptionHelper();
    }

    @Override
    public ResultSet extract(PreparedStatement statement) {
        if (this.isTypeOf(statement, CallableStatement.class)) {
            CallableStatement callableStatement = (CallableStatement)statement;
            return this.extract(callableStatement);
        }
        try {
            ResultSet rs;
            try {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startStatementExecution();
                rs = statement.executeQuery();
            }
            finally {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endStatementExecution();
            }
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "could not extract ResultSet");
        }
    }

    private boolean isTypeOf(Statement statement, Class<? extends Statement> type) {
        if (this.isJdbc4) {
            try {
                return statement.isWrapperFor(type);
            }
            catch (SQLException sQLException) {
            }
            catch (Throwable e) {
                this.isJdbc4 = false;
            }
        }
        return type.isInstance(statement);
    }

    @Override
    public ResultSet extract(CallableStatement callableStatement) {
        try {
            ResultSet rs;
            try {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startStatementExecution();
                rs = this.dialect.getResultSet(callableStatement);
            }
            finally {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endStatementExecution();
            }
            this.postExtract(rs, callableStatement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "could not extract ResultSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet extract(Statement statement, String sql) {
        this.sqlStatementLogger.logStatement(sql);
        try {
            ResultSet rs;
            try {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startStatementExecution();
                rs = statement.executeQuery(sql);
            }
            finally {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endStatementExecution();
            }
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "could not extract ResultSet");
        }
    }

    @Override
    public ResultSet execute(PreparedStatement statement) {
        try {
            ResultSet rs;
            try {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startStatementExecution();
                if (!statement.execute()) {
                    while (!statement.getMoreResults() && statement.getUpdateCount() != -1) {
                    }
                }
                rs = statement.getResultSet();
            }
            finally {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endStatementExecution();
            }
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "could not execute statement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet execute(Statement statement, String sql) {
        this.sqlStatementLogger.logStatement(sql);
        try {
            ResultSet rs;
            try {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startStatementExecution();
                if (!statement.execute(sql)) {
                    while (!statement.getMoreResults() && statement.getUpdateCount() != -1) {
                    }
                }
                rs = statement.getResultSet();
            }
            finally {
                this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endStatementExecution();
            }
            this.postExtract(rs, statement);
            return rs;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "could not execute statement");
        }
    }

    @Override
    public int executeUpdate(PreparedStatement statement) {
        try {
            this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startStatementExecution();
            int n = statement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "could not execute statement");
        }
        finally {
            this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endStatementExecution();
        }
    }

    @Override
    public int executeUpdate(Statement statement, String sql) {
        this.sqlStatementLogger.logStatement(sql);
        try {
            this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().startStatementExecution();
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper.convert(e, "could not execute statement");
        }
        finally {
            this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().endStatementExecution();
        }
    }

    private void postExtract(ResultSet rs, Statement st) {
        if (rs != null) {
            this.jdbcCoordinator.register(rs, st);
        }
    }
}

