/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.cache.spi.NaturalIdCacheKey;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.EntityEntryContext;
import org.hibernate.engine.internal.NaturalIdXrefDelegate;
import org.hibernate.engine.loading.internal.LoadContexts;
import org.hibernate.engine.spi.AssociationKey;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ConcurrentReferenceHashMap;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulPersistenceContext
implements PersistenceContext {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)StatefulPersistenceContext.class.getName());
    private static final boolean TRACE_ENABLED = LOG.isTraceEnabled();
    private static final int INIT_COLL_SIZE = 8;
    private SessionImplementor session;
    private Map<EntityKey, Object> entitiesByKey;
    private Map<EntityUniqueKey, Object> entitiesByUniqueKey;
    private EntityEntryContext entityEntryContext;
    private ConcurrentMap<EntityKey, Object> proxiesByKey;
    private Map<EntityKey, Object> entitySnapshotsByKey;
    private Map<Object, PersistentCollection> arrayHolders;
    private IdentityMap<PersistentCollection, CollectionEntry> collectionEntries;
    private Map<CollectionKey, PersistentCollection> collectionsByKey;
    private HashSet<EntityKey> nullifiableEntityKeys;
    private HashSet<AssociationKey> nullAssociations;
    private List<PersistentCollection> nonlazyCollections;
    private Map<CollectionKey, PersistentCollection> unownedCollections;
    private Map<Object, Object> parentsByChild;
    private int cascading;
    private int loadCounter;
    private int removeOrphanBeforeUpdatesCounter;
    private boolean flushing;
    private boolean defaultReadOnly;
    private boolean hasNonReadOnlyEntities;
    private LoadContexts loadContexts;
    private BatchFetchQueue batchFetchQueue;
    private HashMap<String, List<Serializable>> insertedKeysMap;
    private final NaturalIdXrefDelegate naturalIdXrefDelegate = new NaturalIdXrefDelegate(this);
    private final PersistenceContext.NaturalIdHelper naturalIdHelper = new PersistenceContext.NaturalIdHelper(){

        @Override
        public void cacheNaturalIdCrossReferenceFromLoad(EntityPersister persister, Serializable id, Object[] naturalIdValues) {
            if (!persister.hasNaturalIdentifier()) {
                return;
            }
            persister = StatefulPersistenceContext.this.locateProperPersister(persister);
            boolean justAddedLocally = StatefulPersistenceContext.this.naturalIdXrefDelegate.cacheNaturalIdCrossReference(persister, id, naturalIdValues);
            if (justAddedLocally && persister.hasNaturalIdCache()) {
                this.managedSharedCacheEntries(persister, id, naturalIdValues, null, CachedNaturalIdValueSource.LOAD);
            }
        }

        @Override
        public void manageLocalNaturalIdCrossReference(EntityPersister persister, Serializable id, Object[] state, Object[] previousState, CachedNaturalIdValueSource source) {
            if (!persister.hasNaturalIdentifier()) {
                return;
            }
            persister = StatefulPersistenceContext.this.locateProperPersister(persister);
            Object[] naturalIdValues = this.extractNaturalIdValues(state, persister);
            StatefulPersistenceContext.this.naturalIdXrefDelegate.cacheNaturalIdCrossReference(persister, id, naturalIdValues);
        }

        @Override
        public void manageSharedNaturalIdCrossReference(EntityPersister persister, Serializable id, Object[] state, Object[] previousState, CachedNaturalIdValueSource source) {
            if (!persister.hasNaturalIdentifier()) {
                return;
            }
            if (!persister.hasNaturalIdCache()) {
                return;
            }
            persister = StatefulPersistenceContext.this.locateProperPersister(persister);
            Object[] naturalIdValues = this.extractNaturalIdValues(state, persister);
            Object[] previousNaturalIdValues = previousState == null ? null : this.extractNaturalIdValues(previousState, persister);
            this.managedSharedCacheEntries(persister, id, naturalIdValues, previousNaturalIdValues, source);
        }

        private void managedSharedCacheEntries(EntityPersister persister, final Serializable id, Object[] naturalIdValues, Object[] previousNaturalIdValues, CachedNaturalIdValueSource source) {
            final NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
            final NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(naturalIdValues, persister, StatefulPersistenceContext.this.session);
            final SessionFactoryImplementor factory = StatefulPersistenceContext.this.session.getFactory();
            switch (source) {
                case LOAD: {
                    if (CacheHelper.fromSharedCache(StatefulPersistenceContext.this.session, naturalIdCacheKey, naturalIdCacheAccessStrategy) != null) {
                        return;
                    }
                    boolean put = naturalIdCacheAccessStrategy.putFromLoad(naturalIdCacheKey, id, StatefulPersistenceContext.this.session.getTimestamp(), null);
                    if (!put || !factory.getStatistics().isStatisticsEnabled()) break;
                    factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                    break;
                }
                case INSERT: {
                    boolean put = naturalIdCacheAccessStrategy.insert(naturalIdCacheKey, id);
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                    }
                    ((EventSource)StatefulPersistenceContext.this.session).getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                        public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
                            if (success) {
                                boolean put = naturalIdCacheAccessStrategy.afterInsert(naturalIdCacheKey, id);
                                if (put && factory.getStatistics().isStatisticsEnabled()) {
                                    factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                                }
                            } else {
                                naturalIdCacheAccessStrategy.evict(naturalIdCacheKey);
                            }
                        }
                    });
                    break;
                }
                case UPDATE: {
                    final NaturalIdCacheKey previousCacheKey = new NaturalIdCacheKey(previousNaturalIdValues, persister, StatefulPersistenceContext.this.session);
                    if (naturalIdCacheKey.equals(previousCacheKey)) {
                        return;
                    }
                    final SoftLock removalLock = naturalIdCacheAccessStrategy.lockItem(previousCacheKey, null);
                    naturalIdCacheAccessStrategy.remove(previousCacheKey);
                    final SoftLock lock = naturalIdCacheAccessStrategy.lockItem(naturalIdCacheKey, null);
                    boolean put = naturalIdCacheAccessStrategy.update(naturalIdCacheKey, id);
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                    }
                    ((EventSource)StatefulPersistenceContext.this.session).getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                        public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
                            naturalIdCacheAccessStrategy.unlockItem(previousCacheKey, removalLock);
                            if (success) {
                                boolean put = naturalIdCacheAccessStrategy.afterUpdate(naturalIdCacheKey, id, lock);
                                if (put && factory.getStatistics().isStatisticsEnabled()) {
                                    factory.getStatisticsImplementor().naturalIdCachePut(naturalIdCacheAccessStrategy.getRegion().getName());
                                }
                            } else {
                                naturalIdCacheAccessStrategy.unlockItem(naturalIdCacheKey, lock);
                            }
                        }
                    });
                    break;
                }
                default: {
                    LOG.debug("Unexpected CachedNaturalIdValueSource [" + (Object)((Object)source) + "]");
                }
            }
        }

        @Override
        public Object[] removeLocalNaturalIdCrossReference(EntityPersister persister, Serializable id, Object[] state) {
            if (!persister.hasNaturalIdentifier()) {
                return null;
            }
            persister = StatefulPersistenceContext.this.locateProperPersister(persister);
            Object[] naturalIdValues = StatefulPersistenceContext.this.getNaturalIdValues(state, persister);
            Object[] localNaturalIdValues = StatefulPersistenceContext.this.naturalIdXrefDelegate.removeNaturalIdCrossReference(persister, id, naturalIdValues);
            return localNaturalIdValues != null ? localNaturalIdValues : naturalIdValues;
        }

        @Override
        public void removeSharedNaturalIdCrossReference(EntityPersister persister, Serializable id, Object[] naturalIdValues) {
            if (!persister.hasNaturalIdentifier()) {
                return;
            }
            if (!persister.hasNaturalIdCache()) {
                return;
            }
            persister = StatefulPersistenceContext.this.locateProperPersister(persister);
            NaturalIdRegionAccessStrategy naturalIdCacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
            NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(naturalIdValues, persister, StatefulPersistenceContext.this.session);
            naturalIdCacheAccessStrategy.evict(naturalIdCacheKey);
        }

        @Override
        public Object[] findCachedNaturalId(EntityPersister persister, Serializable pk) {
            return StatefulPersistenceContext.this.naturalIdXrefDelegate.findCachedNaturalId(StatefulPersistenceContext.this.locateProperPersister(persister), pk);
        }

        @Override
        public Serializable findCachedNaturalIdResolution(EntityPersister persister, Object[] naturalIdValues) {
            return StatefulPersistenceContext.this.naturalIdXrefDelegate.findCachedNaturalIdResolution(StatefulPersistenceContext.this.locateProperPersister(persister), naturalIdValues);
        }

        @Override
        public Object[] extractNaturalIdValues(Object[] state, EntityPersister persister) {
            int[] naturalIdPropertyIndexes = persister.getNaturalIdentifierProperties();
            if (state.length == naturalIdPropertyIndexes.length) {
                return state;
            }
            Object[] naturalIdValues = new Object[naturalIdPropertyIndexes.length];
            for (int i = 0; i < naturalIdPropertyIndexes.length; ++i) {
                naturalIdValues[i] = state[naturalIdPropertyIndexes[i]];
            }
            return naturalIdValues;
        }

        @Override
        public Object[] extractNaturalIdValues(Object entity, EntityPersister persister) {
            if (entity == null) {
                throw new AssertionFailure("Entity from which to extract natural id value(s) cannot be null");
            }
            if (persister == null) {
                throw new AssertionFailure("Persister to use in extracting natural id value(s) cannot be null");
            }
            int[] naturalIdentifierProperties = persister.getNaturalIdentifierProperties();
            Object[] naturalIdValues = new Object[naturalIdentifierProperties.length];
            for (int i = 0; i < naturalIdentifierProperties.length; ++i) {
                naturalIdValues[i] = persister.getPropertyValue(entity, naturalIdentifierProperties[i]);
            }
            return naturalIdValues;
        }

        @Override
        public Collection<Serializable> getCachedPkResolutions(EntityPersister entityPersister) {
            return StatefulPersistenceContext.this.naturalIdXrefDelegate.getCachedPkResolutions(entityPersister);
        }

        @Override
        public void handleSynchronization(EntityPersister persister, Serializable pk, Object entity) {
            boolean changed;
            if (!persister.hasNaturalIdentifier()) {
                return;
            }
            persister = StatefulPersistenceContext.this.locateProperPersister(persister);
            Object[] naturalIdValuesFromCurrentObjectState = this.extractNaturalIdValues(entity, persister);
            boolean bl = changed = !StatefulPersistenceContext.this.naturalIdXrefDelegate.sameAsCached(persister, pk, naturalIdValuesFromCurrentObjectState);
            if (changed) {
                Object[] cachedNaturalIdValues = StatefulPersistenceContext.this.naturalIdXrefDelegate.findCachedNaturalId(persister, pk);
                StatefulPersistenceContext.this.naturalIdXrefDelegate.cacheNaturalIdCrossReference(persister, pk, naturalIdValuesFromCurrentObjectState);
                StatefulPersistenceContext.this.naturalIdXrefDelegate.stashInvalidNaturalIdReference(persister, cachedNaturalIdValues);
                this.removeSharedNaturalIdCrossReference(persister, pk, cachedNaturalIdValues);
            }
        }

        @Override
        public void cleanupFromSynchronizations() {
            StatefulPersistenceContext.this.naturalIdXrefDelegate.unStashInvalidNaturalIdReferences();
        }

        @Override
        public void handleEviction(Object object, EntityPersister persister, Serializable identifier) {
            StatefulPersistenceContext.this.naturalIdXrefDelegate.removeNaturalIdCrossReference(persister, identifier, this.findCachedNaturalId(persister, identifier));
        }
    };

    public StatefulPersistenceContext(SessionImplementor session) {
        this.session = session;
        this.entitiesByKey = new HashMap<EntityKey, Object>(8);
        this.entitiesByUniqueKey = new HashMap<EntityUniqueKey, Object>(8);
        this.proxiesByKey = new ConcurrentReferenceHashMap<EntityKey, Object>(8, 0.75f, 1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, null);
        this.entitySnapshotsByKey = new HashMap<EntityKey, Object>(8);
        this.entityEntryContext = new EntityEntryContext();
        this.collectionEntries = IdentityMap.instantiateSequenced(8);
        this.parentsByChild = new IdentityHashMap<Object, Object>(8);
        this.collectionsByKey = new HashMap<CollectionKey, PersistentCollection>(8);
        this.arrayHolders = new IdentityHashMap<Object, PersistentCollection>(8);
        this.nullifiableEntityKeys = new HashSet();
        this.initTransientState();
    }

    private void initTransientState() {
        this.nullAssociations = new HashSet(8);
        this.nonlazyCollections = new ArrayList<PersistentCollection>(8);
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    public SessionImplementor getSession() {
        return this.session;
    }

    @Override
    public LoadContexts getLoadContexts() {
        if (this.loadContexts == null) {
            this.loadContexts = new LoadContexts(this);
        }
        return this.loadContexts;
    }

    @Override
    public void addUnownedCollection(CollectionKey key, PersistentCollection collection) {
        if (this.unownedCollections == null) {
            this.unownedCollections = new HashMap<CollectionKey, PersistentCollection>(8);
        }
        this.unownedCollections.put(key, collection);
    }

    @Override
    public PersistentCollection useUnownedCollection(CollectionKey key) {
        return this.unownedCollections == null ? null : this.unownedCollections.remove(key);
    }

    @Override
    public BatchFetchQueue getBatchFetchQueue() {
        if (this.batchFetchQueue == null) {
            this.batchFetchQueue = new BatchFetchQueue(this);
        }
        return this.batchFetchQueue;
    }

    @Override
    public void clear() {
        for (Object o : this.proxiesByKey.values()) {
            if (o == null) continue;
            ((HibernateProxy)o).getHibernateLazyInitializer().unsetSession();
        }
        for (Map.Entry<PersistentCollection, CollectionEntry> aCollectionEntryArray : IdentityMap.concurrentEntries(this.collectionEntries)) {
            aCollectionEntryArray.getKey().unsetSession(this.getSession());
        }
        this.arrayHolders.clear();
        this.entitiesByKey.clear();
        this.entitiesByUniqueKey.clear();
        this.entityEntryContext.clear();
        this.parentsByChild.clear();
        this.entitySnapshotsByKey.clear();
        this.collectionsByKey.clear();
        this.collectionEntries.clear();
        if (this.unownedCollections != null) {
            this.unownedCollections.clear();
        }
        this.proxiesByKey.clear();
        this.nullifiableEntityKeys.clear();
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.clear();
        }
        this.hasNonReadOnlyEntities = false;
        if (this.loadContexts != null) {
            this.loadContexts.cleanup();
        }
        this.naturalIdXrefDelegate.clear();
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    @Override
    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public boolean hasNonReadOnlyEntities() {
        return this.hasNonReadOnlyEntities;
    }

    @Override
    public void setEntryStatus(EntityEntry entry, Status status) {
        entry.setStatus(status);
        this.setHasNonReadOnlyEnties(status);
    }

    private void setHasNonReadOnlyEnties(Status status) {
        if (status == Status.DELETED || status == Status.MANAGED || status == Status.SAVING) {
            this.hasNonReadOnlyEntities = true;
        }
    }

    @Override
    public void afterTransactionCompletion() {
        this.cleanUpInsertedKeysAfterTransaction();
        this.entityEntryContext.downgradeLocks();
    }

    @Override
    public Object[] getDatabaseSnapshot(Serializable id, EntityPersister persister) throws HibernateException {
        EntityKey key = this.session.generateEntityKey(id, persister);
        Object cached = this.entitySnapshotsByKey.get(key);
        if (cached != null) {
            return cached == NO_ROW ? null : (Object[])cached;
        }
        Object[] snapshot = persister.getDatabaseSnapshot(id, this.session);
        this.entitySnapshotsByKey.put(key, snapshot == null ? NO_ROW : snapshot);
        return snapshot;
    }

    @Override
    public Object[] getNaturalIdSnapshot(Serializable id, EntityPersister persister) throws HibernateException {
        if (!persister.hasNaturalIdentifier()) {
            return null;
        }
        Object[] cachedValue = this.naturalIdHelper.findCachedNaturalId(persister = this.locateProperPersister(persister), id);
        if (cachedValue != null) {
            return cachedValue;
        }
        if (persister.getEntityMetamodel().hasImmutableNaturalId()) {
            Object[] dbValue = persister.getNaturalIdentifierSnapshot(id, this.session);
            this.naturalIdHelper.cacheNaturalIdCrossReferenceFromLoad(persister, id, dbValue);
            return dbValue;
        }
        int[] props = persister.getNaturalIdentifierProperties();
        Object[] entitySnapshot = this.getDatabaseSnapshot(id, persister);
        if (entitySnapshot == NO_ROW || entitySnapshot == null) {
            return null;
        }
        Object[] naturalIdSnapshotSubSet = new Object[props.length];
        for (int i = 0; i < props.length; ++i) {
            naturalIdSnapshotSubSet[i] = entitySnapshot[props[i]];
        }
        this.naturalIdHelper.cacheNaturalIdCrossReferenceFromLoad(persister, id, naturalIdSnapshotSubSet);
        return naturalIdSnapshotSubSet;
    }

    private EntityPersister locateProperPersister(EntityPersister persister) {
        return this.session.getFactory().getEntityPersister(persister.getRootEntityName());
    }

    @Override
    public Object[] getCachedDatabaseSnapshot(EntityKey key) {
        Object snapshot = this.entitySnapshotsByKey.get(key);
        if (snapshot == NO_ROW) {
            throw new IllegalStateException("persistence context reported no row snapshot for " + MessageHelper.infoString(key.getEntityName(), key.getIdentifier()));
        }
        return (Object[])snapshot;
    }

    @Override
    public void addEntity(EntityKey key, Object entity) {
        this.entitiesByKey.put(key, entity);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(key);
    }

    @Override
    public Object getEntity(EntityKey key) {
        return this.entitiesByKey.get(key);
    }

    @Override
    public boolean containsEntity(EntityKey key) {
        return this.entitiesByKey.containsKey(key);
    }

    @Override
    public Object removeEntity(EntityKey key) {
        Object entity = this.entitiesByKey.remove(key);
        Iterator<Object> itr = this.entitiesByUniqueKey.values().iterator();
        while (itr.hasNext()) {
            if (itr.next() != entity) continue;
            itr.remove();
        }
        this.parentsByChild.clear();
        this.entitySnapshotsByKey.remove(key);
        this.nullifiableEntityKeys.remove(key);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(key);
        this.getBatchFetchQueue().removeSubselect(key);
        return entity;
    }

    @Override
    public Object getEntity(EntityUniqueKey euk) {
        return this.entitiesByUniqueKey.get(euk);
    }

    @Override
    public void addEntity(EntityUniqueKey euk, Object entity) {
        this.entitiesByUniqueKey.put(euk, entity);
    }

    @Override
    public EntityEntry getEntry(Object entity) {
        return this.entityEntryContext.getEntityEntry(entity);
    }

    @Override
    public EntityEntry removeEntry(Object entity) {
        return this.entityEntryContext.removeEntityEntry(entity);
    }

    @Override
    public boolean isEntryFor(Object entity) {
        return this.entityEntryContext.hasEntityEntry(entity);
    }

    @Override
    public CollectionEntry getCollectionEntry(PersistentCollection coll) {
        return this.collectionEntries.get(coll);
    }

    @Override
    public EntityEntry addEntity(Object entity, Status status, Object[] loadedState, EntityKey entityKey, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        this.addEntity(entityKey, entity);
        return this.addEntry(entity, status, loadedState, null, entityKey.getIdentifier(), version, lockMode, existsInDatabase, persister, disableVersionIncrement, lazyPropertiesAreUnfetched);
    }

    @Override
    public EntityEntry addEntry(Object entity, Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        EntityEntry e = new EntityEntry(status, loadedState, rowId, id, version, lockMode, existsInDatabase, persister, disableVersionIncrement, lazyPropertiesAreUnfetched, this);
        this.entityEntryContext.addEntityEntry(entity, e);
        this.setHasNonReadOnlyEnties(status);
        return e;
    }

    @Override
    public boolean containsCollection(PersistentCollection collection) {
        return this.collectionEntries.containsKey(collection);
    }

    @Override
    public boolean containsProxy(Object entity) {
        return this.proxiesByKey.containsValue(entity);
    }

    @Override
    public boolean reassociateIfUninitializedProxy(Object value) throws MappingException {
        if (value instanceof ElementWrapper) {
            value = ((ElementWrapper)value).getElement();
        }
        if (!Hibernate.isInitialized(value)) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return true;
        }
        return false;
    }

    @Override
    public void reassociateProxy(Object value, Serializable id) throws MappingException {
        if (value instanceof ElementWrapper) {
            value = ((ElementWrapper)value).getElement();
        }
        if (value instanceof HibernateProxy) {
            LOG.debugf("Setting proxy identifier: %s", id);
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            li.setIdentifier(id);
            this.reassociateProxy(li, proxy);
        }
    }

    private void reassociateProxy(LazyInitializer li, HibernateProxy proxy) {
        if (li.getSession() != this.getSession()) {
            EntityPersister persister = this.session.getFactory().getEntityPersister(li.getEntityName());
            EntityKey key = this.session.generateEntityKey(li.getIdentifier(), persister);
            this.proxiesByKey.putIfAbsent(key, proxy);
            proxy.getHibernateLazyInitializer().setSession(this.session);
        }
    }

    @Override
    public Object unproxy(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof ElementWrapper) {
            maybeProxy = ((ElementWrapper)maybeProxy).getElement();
        }
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                throw new PersistentObjectException("object was an uninitialized proxy for " + li.getEntityName());
            }
            return li.getImplementation();
        }
        return maybeProxy;
    }

    @Override
    public Object unproxyAndReassociate(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof ElementWrapper) {
            maybeProxy = ((ElementWrapper)maybeProxy).getElement();
        }
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            this.reassociateProxy(li, proxy);
            return li.getImplementation();
        }
        return maybeProxy;
    }

    @Override
    public void checkUniqueness(EntityKey key, Object object) throws HibernateException {
        Object entity = this.getEntity(key);
        if (entity == object) {
            throw new AssertionFailure("object already associated, but no entry was found");
        }
        if (entity != null) {
            throw new NonUniqueObjectException(key.getIdentifier(), key.getEntityName());
        }
    }

    @Override
    public Object narrowProxy(Object proxy, EntityPersister persister, EntityKey key, Object object) throws HibernateException {
        Class concreteProxyClass = persister.getConcreteProxyClass();
        boolean alreadyNarrow = concreteProxyClass.isInstance(proxy);
        if (!alreadyNarrow) {
            Object impl;
            LOG.narrowingProxy(concreteProxyClass);
            if (object != null) {
                this.proxiesByKey.remove(key);
                return object;
            }
            HibernateProxy originalHibernateProxy = (HibernateProxy)proxy;
            if (!originalHibernateProxy.getHibernateLazyInitializer().isUninitialized() && concreteProxyClass.isInstance(impl = originalHibernateProxy.getHibernateLazyInitializer().getImplementation())) {
                this.proxiesByKey.remove(key);
                return impl;
            }
            HibernateProxy narrowedProxy = (HibernateProxy)persister.createProxy(key.getIdentifier(), this.session);
            boolean readOnlyOrig = originalHibernateProxy.getHibernateLazyInitializer().isReadOnly();
            narrowedProxy.getHibernateLazyInitializer().setReadOnly(readOnlyOrig);
            return narrowedProxy;
        }
        if (object != null) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            li.setImplementation(object);
        }
        return proxy;
    }

    @Override
    public Object proxyFor(EntityPersister persister, EntityKey key, Object impl) throws HibernateException {
        if (!persister.hasProxy()) {
            return impl;
        }
        Object proxy = this.proxiesByKey.get(key);
        return proxy != null ? this.narrowProxy(proxy, persister, key, impl) : impl;
    }

    @Override
    public Object proxyFor(Object impl) throws HibernateException {
        EntityEntry e = this.getEntry(impl);
        if (e == null) {
            return impl;
        }
        return this.proxyFor(e.getPersister(), e.getEntityKey(), impl);
    }

    @Override
    public Object getCollectionOwner(Serializable key, CollectionPersister collectionPersister) throws MappingException {
        EntityPersister ownerPersister = collectionPersister.getOwnerEntityPersister();
        if (ownerPersister.getIdentifierType().getReturnedClass().isInstance(key)) {
            return this.getEntity(this.session.generateEntityKey(key, collectionPersister.getOwnerEntityPersister()));
        }
        if (ownerPersister.isInstance(key)) {
            Serializable owenerId = ownerPersister.getIdentifier(key, this.session);
            if (owenerId == null) {
                return null;
            }
            return this.getEntity(this.session.generateEntityKey(owenerId, ownerPersister));
        }
        CollectionType collectionType = collectionPersister.getCollectionType();
        if (collectionType.getLHSPropertyName() != null) {
            Object owner = this.getEntity(new EntityUniqueKey(ownerPersister.getEntityName(), collectionType.getLHSPropertyName(), key, collectionPersister.getKeyType(), ownerPersister.getEntityMode(), this.session.getFactory()));
            if (owner != null) {
                return owner;
            }
            Serializable ownerId = ownerPersister.getIdByUniqueKey(key, collectionType.getLHSPropertyName(), this.session);
            return this.getEntity(this.session.generateEntityKey(ownerId, ownerPersister));
        }
        return this.getEntity(this.session.generateEntityKey(key, collectionPersister.getOwnerEntityPersister()));
    }

    @Override
    public Object getLoadedCollectionOwnerOrNull(PersistentCollection collection) {
        CollectionEntry ce = this.getCollectionEntry(collection);
        if (ce.getLoadedPersister() == null) {
            return null;
        }
        Object loadedOwner = null;
        Serializable entityId = this.getLoadedCollectionOwnerIdOrNull(ce);
        if (entityId != null) {
            loadedOwner = this.getCollectionOwner(entityId, ce.getLoadedPersister());
        }
        return loadedOwner;
    }

    @Override
    public Serializable getLoadedCollectionOwnerIdOrNull(PersistentCollection collection) {
        return this.getLoadedCollectionOwnerIdOrNull(this.getCollectionEntry(collection));
    }

    private Serializable getLoadedCollectionOwnerIdOrNull(CollectionEntry ce) {
        if (ce == null || ce.getLoadedKey() == null || ce.getLoadedPersister() == null) {
            return null;
        }
        return ce.getLoadedPersister().getCollectionType().getIdOfOwnerOrNull(ce.getLoadedKey(), this.session);
    }

    @Override
    public void addUninitializedCollection(CollectionPersister persister, PersistentCollection collection, Serializable id) {
        CollectionEntry ce = new CollectionEntry(collection, persister, id, this.flushing);
        this.addCollection(collection, ce, id);
        if (persister.getBatchSize() > 1) {
            this.getBatchFetchQueue().addBatchLoadableCollection(collection, ce);
        }
    }

    @Override
    public void addUninitializedDetachedCollection(CollectionPersister persister, PersistentCollection collection) {
        CollectionEntry ce = new CollectionEntry(persister, collection.getKey());
        this.addCollection(collection, ce, collection.getKey());
        if (persister.getBatchSize() > 1) {
            this.getBatchFetchQueue().addBatchLoadableCollection(collection, ce);
        }
    }

    @Override
    public void addNewCollection(CollectionPersister persister, PersistentCollection collection) throws HibernateException {
        this.addCollection(collection, persister);
    }

    private void addCollection(PersistentCollection coll, CollectionEntry entry, Serializable key) {
        this.collectionEntries.put(coll, entry);
        CollectionKey collectionKey = new CollectionKey(entry.getLoadedPersister(), key);
        PersistentCollection old = this.collectionsByKey.put(collectionKey, coll);
        if (old != null) {
            if (old == coll) {
                throw new AssertionFailure("bug adding collection twice");
            }
            old.unsetSession(this.session);
            this.collectionEntries.remove(old);
        }
    }

    private void addCollection(PersistentCollection collection, CollectionPersister persister) {
        CollectionEntry ce = new CollectionEntry(persister, collection);
        this.collectionEntries.put(collection, ce);
    }

    @Override
    public void addInitializedDetachedCollection(CollectionPersister collectionPersister, PersistentCollection collection) throws HibernateException {
        if (collection.isUnreferenced()) {
            this.addCollection(collection, collectionPersister);
        } else {
            CollectionEntry ce = new CollectionEntry(collection, this.session.getFactory());
            this.addCollection(collection, ce, collection.getKey());
        }
    }

    @Override
    public CollectionEntry addInitializedCollection(CollectionPersister persister, PersistentCollection collection, Serializable id) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(collection, persister, id, this.flushing);
        ce.postInitialize(collection);
        this.addCollection(collection, ce, id);
        return ce;
    }

    @Override
    public PersistentCollection getCollection(CollectionKey collectionKey) {
        return this.collectionsByKey.get(collectionKey);
    }

    @Override
    public void addNonLazyCollection(PersistentCollection collection) {
        this.nonlazyCollections.add(collection);
    }

    @Override
    public void initializeNonLazyCollections() throws HibernateException {
        if (this.loadCounter == 0) {
            if (TRACE_ENABLED) {
                LOG.trace("Initializing non-lazy collections");
            }
            ++this.loadCounter;
            try {
                int size;
                while ((size = this.nonlazyCollections.size()) > 0) {
                    this.nonlazyCollections.remove(size - 1).forceInitialization();
                }
            }
            finally {
                --this.loadCounter;
                this.clearNullProperties();
            }
        }
    }

    @Override
    public PersistentCollection getCollectionHolder(Object array) {
        return this.arrayHolders.get(array);
    }

    @Override
    public void addCollectionHolder(PersistentCollection holder) {
        this.arrayHolders.put(holder.getValue(), holder);
    }

    @Override
    public PersistentCollection removeCollectionHolder(Object array) {
        return this.arrayHolders.remove(array);
    }

    @Override
    public Serializable getSnapshot(PersistentCollection coll) {
        return this.getCollectionEntry(coll).getSnapshot();
    }

    @Override
    public CollectionEntry getCollectionEntryOrNull(Object collection) {
        PersistentCollection coll;
        if (collection instanceof PersistentCollection) {
            coll = (PersistentCollection)collection;
        } else {
            coll = this.getCollectionHolder(collection);
            if (coll == null) {
                Iterator<PersistentCollection> wrappers = this.collectionEntries.keyIterator();
                while (wrappers.hasNext()) {
                    PersistentCollection pc = wrappers.next();
                    if (!pc.isWrapper(collection)) continue;
                    coll = pc;
                    break;
                }
            }
        }
        return coll == null ? null : this.getCollectionEntry(coll);
    }

    @Override
    public Object getProxy(EntityKey key) {
        return this.proxiesByKey.get(key);
    }

    @Override
    public void addProxy(EntityKey key, Object proxy) {
        this.proxiesByKey.put(key, proxy);
    }

    @Override
    public Object removeProxy(EntityKey key) {
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.removeBatchLoadableEntityKey(key);
            this.batchFetchQueue.removeSubselect(key);
        }
        return this.proxiesByKey.remove(key);
    }

    @Override
    public HashSet getNullifiableEntityKeys() {
        return this.nullifiableEntityKeys;
    }

    @Override
    public Map getEntitiesByKey() {
        return this.entitiesByKey;
    }

    public Map getProxiesByKey() {
        return this.proxiesByKey;
    }

    @Override
    public int getNumberOfManagedEntities() {
        return this.entityEntryContext.getNumberOfManagedEntities();
    }

    @Override
    public Map getEntityEntries() {
        return null;
    }

    @Override
    public Map getCollectionEntries() {
        return this.collectionEntries;
    }

    @Override
    public Map getCollectionsByKey() {
        return this.collectionsByKey;
    }

    @Override
    public int getCascadeLevel() {
        return this.cascading;
    }

    @Override
    public int incrementCascadeLevel() {
        return ++this.cascading;
    }

    @Override
    public int decrementCascadeLevel() {
        return --this.cascading;
    }

    @Override
    public boolean isFlushing() {
        return this.flushing;
    }

    @Override
    public void setFlushing(boolean flushing) {
        boolean afterFlush = this.flushing && !flushing;
        this.flushing = flushing;
        if (afterFlush) {
            this.getNaturalIdHelper().cleanupFromSynchronizations();
        }
    }

    public boolean isRemovingOrphanBeforeUpates() {
        return this.removeOrphanBeforeUpdatesCounter > 0;
    }

    public void beginRemoveOrphanBeforeUpdates() {
        if (this.getCascadeLevel() < 1) {
            throw new IllegalStateException("Attempt to remove orphan when not cascading.");
        }
        if (this.removeOrphanBeforeUpdatesCounter >= this.getCascadeLevel()) {
            throw new IllegalStateException(String.format("Cascade level [%d] is out of sync with removeOrphanBeforeUpdatesCounter [%d] before incrementing removeOrphanBeforeUpdatesCounter", this.getCascadeLevel(), this.removeOrphanBeforeUpdatesCounter));
        }
        ++this.removeOrphanBeforeUpdatesCounter;
    }

    public void endRemoveOrphanBeforeUpdates() {
        if (this.getCascadeLevel() < 1) {
            throw new IllegalStateException("Finished removing orphan when not cascading.");
        }
        if (this.removeOrphanBeforeUpdatesCounter > this.getCascadeLevel()) {
            throw new IllegalStateException(String.format("Cascade level [%d] is out of sync with removeOrphanBeforeUpdatesCounter [%d] before decrementing removeOrphanBeforeUpdatesCounter", this.getCascadeLevel(), this.removeOrphanBeforeUpdatesCounter));
        }
        --this.removeOrphanBeforeUpdatesCounter;
    }

    @Override
    public void beforeLoad() {
        ++this.loadCounter;
    }

    @Override
    public void afterLoad() {
        --this.loadCounter;
    }

    @Override
    public boolean isLoadFinished() {
        return this.loadCounter == 0;
    }

    @Override
    public String toString() {
        return "PersistenceContext[entityKeys=" + this.entitiesByKey.keySet() + ",collectionKeys=" + this.collectionsByKey.keySet() + "]";
    }

    @Override
    public Map.Entry<Object, EntityEntry>[] reentrantSafeEntityEntries() {
        return this.entityEntryContext.reentrantSafeEntityEntries();
    }

    @Override
    public Serializable getOwnerId(String entityName, String propertyName, Object childEntity, Map mergeMap) {
        String collectionRole = entityName + '.' + propertyName;
        EntityPersister persister = this.session.getFactory().getEntityPersister(entityName);
        CollectionPersister collectionPersister = this.session.getFactory().getCollectionPersister(collectionRole);
        Object parent = this.parentsByChild.get(childEntity);
        if (parent != null) {
            EntityEntry entityEntry = this.entityEntryContext.getEntityEntry(parent);
            if (persister.isSubclassEntityName(entityEntry.getEntityName()) && this.isFoundInParent(propertyName, childEntity, persister, collectionPersister, parent)) {
                return this.getEntry(parent).getId();
            }
            this.parentsByChild.remove(childEntity);
        }
        for (Map.Entry<Object, EntityEntry> me : this.reentrantSafeEntityEntries()) {
            EntityEntry entityEntry = me.getValue();
            if (!persister.isSubclassEntityName(entityEntry.getEntityName())) continue;
            Object entityEntryInstance = me.getKey();
            boolean found = this.isFoundInParent(propertyName, childEntity, persister, collectionPersister, entityEntryInstance);
            if (!found && mergeMap != null) {
                Object unmergedInstance = mergeMap.get(entityEntryInstance);
                Object unmergedChild = mergeMap.get(childEntity);
                if (unmergedInstance != null && unmergedChild != null) {
                    found = this.isFoundInParent(propertyName, unmergedChild, persister, collectionPersister, unmergedInstance);
                    LOG.debugf("Detached object being merged (corresponding with a managed entity) has a collection that [%s] the detached child.", found ? "contains" : "does not contain");
                }
            }
            if (!found) continue;
            return entityEntry.getId();
        }
        if (mergeMap != null) {
            for (Object e : mergeMap.entrySet()) {
                HibernateProxy proxy;
                Map.Entry mergeMapEntry = (Map.Entry)e;
                if (!(mergeMapEntry.getKey() instanceof HibernateProxy) || !persister.isSubclassEntityName((proxy = (HibernateProxy)mergeMapEntry.getKey()).getHibernateLazyInitializer().getEntityName())) continue;
                boolean found = this.isFoundInParent(propertyName, childEntity, persister, collectionPersister, mergeMap.get(proxy));
                LOG.debugf("Detached proxy being merged has a collection that [%s] the managed child.", found ? "contains" : "does not contain");
                if (!found) {
                    found = this.isFoundInParent(propertyName, mergeMap.get(childEntity), persister, collectionPersister, mergeMap.get(proxy));
                    LOG.debugf("Detached proxy being merged has a collection that [%s] the detached child being merged..", found ? "contains" : "does not contain");
                }
                if (!found) continue;
                return proxy.getHibernateLazyInitializer().getIdentifier();
            }
        }
        return null;
    }

    private boolean isFoundInParent(String property, Object childEntity, EntityPersister persister, CollectionPersister collectionPersister, Object potentialParent) {
        Object collection = persister.getPropertyValue(potentialParent, property);
        return collection != null && Hibernate.isInitialized(collection) && collectionPersister.getCollectionType().contains(collection, childEntity, this.session);
    }

    @Override
    public Object getIndexInOwner(String entity, String property, Object childEntity, Map mergeMap) {
        EntityPersister persister = this.session.getFactory().getEntityPersister(entity);
        CollectionPersister cp = this.session.getFactory().getCollectionPersister(entity + '.' + property);
        Object parent = this.parentsByChild.get(childEntity);
        if (parent != null) {
            EntityEntry entityEntry = this.entityEntryContext.getEntityEntry(parent);
            if (persister.isSubclassEntityName(entityEntry.getEntityName())) {
                Object index = this.getIndexInParent(property, childEntity, persister, cp, parent);
                if (index == null && mergeMap != null) {
                    Object unMergedInstance = mergeMap.get(parent);
                    Object unMergedChild = mergeMap.get(childEntity);
                    if (unMergedInstance != null && unMergedChild != null) {
                        index = this.getIndexInParent(property, unMergedChild, persister, cp, unMergedInstance);
                        LOG.debugf("A detached object being merged (corresponding to a parent in parentsByChild) has an indexed collection that [%s] the detached child being merged. ", index != null ? "contains" : "does not contain");
                    }
                }
                if (index != null) {
                    return index;
                }
            } else {
                this.parentsByChild.remove(childEntity);
            }
        }
        for (Map.Entry<Object, EntityEntry> me : this.reentrantSafeEntityEntries()) {
            EntityEntry ee = me.getValue();
            if (!persister.isSubclassEntityName(ee.getEntityName())) continue;
            Object instance = me.getKey();
            Object index = this.getIndexInParent(property, childEntity, persister, cp, instance);
            if (index == null && mergeMap != null) {
                Object unMergedInstance = mergeMap.get(instance);
                Object unMergedChild = mergeMap.get(childEntity);
                if (unMergedInstance != null && unMergedChild != null) {
                    index = this.getIndexInParent(property, unMergedChild, persister, cp, unMergedInstance);
                    LOG.debugf("A detached object being merged (corresponding to a managed entity) has an indexed collection that [%s] the detached child being merged. ", index != null ? "contains" : "does not contain");
                }
            }
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private Object getIndexInParent(String property, Object childEntity, EntityPersister persister, CollectionPersister collectionPersister, Object potentialParent) {
        Object collection = persister.getPropertyValue(potentialParent, property);
        if (collection != null && Hibernate.isInitialized(collection)) {
            return collectionPersister.getCollectionType().indexOf(collection, childEntity);
        }
        return null;
    }

    @Override
    public void addNullProperty(EntityKey ownerKey, String propertyName) {
        this.nullAssociations.add(new AssociationKey(ownerKey, propertyName));
    }

    @Override
    public boolean isPropertyNull(EntityKey ownerKey, String propertyName) {
        return this.nullAssociations.contains(new AssociationKey(ownerKey, propertyName));
    }

    private void clearNullProperties() {
        this.nullAssociations.clear();
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        boolean isReadOnly;
        if (entityOrProxy == null) {
            throw new AssertionFailure("object must be non-null.");
        }
        if (entityOrProxy instanceof HibernateProxy) {
            isReadOnly = ((HibernateProxy)entityOrProxy).getHibernateLazyInitializer().isReadOnly();
        } else {
            EntityEntry ee = this.getEntry(entityOrProxy);
            if (ee == null) {
                throw new TransientObjectException("Instance was not associated with this persistence context");
            }
            isReadOnly = ee.isReadOnly();
        }
        return isReadOnly;
    }

    @Override
    public void setReadOnly(Object object, boolean readOnly) {
        if (object == null) {
            throw new AssertionFailure("object must be non-null.");
        }
        if (this.isReadOnly(object) == readOnly) {
            return;
        }
        if (object instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)object;
            this.setProxyReadOnly(proxy, readOnly);
            if (Hibernate.isInitialized(proxy)) {
                this.setEntityReadOnly(proxy.getHibernateLazyInitializer().getImplementation(), readOnly);
            }
        } else {
            this.setEntityReadOnly(object, readOnly);
            Object maybeProxy = this.getSession().getPersistenceContext().proxyFor(object);
            if (maybeProxy instanceof HibernateProxy) {
                this.setProxyReadOnly((HibernateProxy)maybeProxy, readOnly);
            }
        }
    }

    private void setProxyReadOnly(HibernateProxy proxy, boolean readOnly) {
        if (proxy.getHibernateLazyInitializer().getSession() != this.getSession()) {
            throw new AssertionFailure("Attempt to set a proxy to read-only that is associated with a different session");
        }
        proxy.getHibernateLazyInitializer().setReadOnly(readOnly);
    }

    private void setEntityReadOnly(Object entity, boolean readOnly) {
        EntityEntry entry = this.getEntry(entity);
        if (entry == null) {
            throw new TransientObjectException("Instance was not associated with this persistence context");
        }
        entry.setReadOnly(readOnly, entity);
        this.hasNonReadOnlyEntities = this.hasNonReadOnlyEntities || !readOnly;
    }

    @Override
    public void replaceDelayedEntityIdentityInsertKeys(EntityKey oldKey, Serializable generatedId) {
        Object entity = this.entitiesByKey.remove(oldKey);
        EntityEntry oldEntry = this.entityEntryContext.removeEntityEntry(entity);
        this.parentsByChild.clear();
        EntityKey newKey = this.session.generateEntityKey(generatedId, oldEntry.getPersister());
        this.addEntity(newKey, entity);
        this.addEntry(entity, oldEntry.getStatus(), oldEntry.getLoadedState(), oldEntry.getRowId(), generatedId, oldEntry.getVersion(), oldEntry.getLockMode(), oldEntry.isExistsInDatabase(), oldEntry.getPersister(), oldEntry.isBeingReplicated(), oldEntry.isLoadedWithLazyPropertiesUnfetched());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        boolean tracing = LOG.isTraceEnabled();
        if (tracing) {
            LOG.trace("Serializing persisatence-context");
        }
        oos.writeBoolean(this.defaultReadOnly);
        oos.writeBoolean(this.hasNonReadOnlyEntities);
        oos.writeInt(this.entitiesByKey.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.entitiesByKey.size() + "] entitiesByKey entries");
        }
        for (Map.Entry<EntityKey, Object> entry : this.entitiesByKey.entrySet()) {
            entry.getKey().serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.entitiesByUniqueKey.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.entitiesByUniqueKey.size() + "] entitiesByUniqueKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.entitiesByUniqueKey.entrySet()) {
            ((EntityUniqueKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.proxiesByKey.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.proxiesByKey.size() + "] proxiesByKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.proxiesByKey.entrySet()) {
            ((EntityKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.entitySnapshotsByKey.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.entitySnapshotsByKey.size() + "] entitySnapshotsByKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.entitySnapshotsByKey.entrySet()) {
            ((EntityKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        this.entityEntryContext.serialize(oos);
        oos.writeInt(this.collectionsByKey.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.collectionsByKey.size() + "] collectionsByKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.collectionsByKey.entrySet()) {
            ((CollectionKey)entry.getKey()).serialize(oos);
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.collectionEntries.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.collectionEntries.size() + "] collectionEntries entries");
        }
        for (Map.Entry<Object, Object> entry : this.collectionEntries.entrySet()) {
            oos.writeObject(entry.getKey());
            ((CollectionEntry)entry.getValue()).serialize(oos);
        }
        oos.writeInt(this.arrayHolders.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.arrayHolders.size() + "] arrayHolders entries");
        }
        for (Map.Entry<Object, Object> entry : this.arrayHolders.entrySet()) {
            oos.writeObject(entry.getKey());
            oos.writeObject(entry.getValue());
        }
        oos.writeInt(this.nullifiableEntityKeys.size());
        if (tracing) {
            LOG.trace("Starting serialization of [" + this.nullifiableEntityKeys.size() + "] nullifiableEntityKey entries");
        }
        for (EntityKey entityKey : this.nullifiableEntityKeys) {
            entityKey.serialize(oos);
        }
    }

    public static StatefulPersistenceContext deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        boolean tracing = LOG.isTraceEnabled();
        if (tracing) {
            LOG.trace("Serializing persistent-context");
        }
        StatefulPersistenceContext rtn = new StatefulPersistenceContext(session);
        SessionFactoryImplementor sfi = session.getFactory();
        try {
            int i;
            rtn.defaultReadOnly = ois.readBoolean();
            rtn.hasNonReadOnlyEntities = ois.readBoolean();
            int count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] entitiesByKey entries");
            }
            rtn.entitiesByKey = new HashMap<EntityKey, Object>(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.entitiesByKey.put(EntityKey.deserialize(ois, sfi), ois.readObject());
            }
            count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] entitiesByUniqueKey entries");
            }
            rtn.entitiesByUniqueKey = new HashMap<EntityUniqueKey, Object>(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.entitiesByUniqueKey.put(EntityUniqueKey.deserialize(ois, session), ois.readObject());
            }
            count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] proxiesByKey entries");
            }
            rtn.proxiesByKey = new ConcurrentReferenceHashMap<EntityKey, Object>(count < 8 ? 8 : count, 0.75f, 1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, null);
            for (i = 0; i < count; ++i) {
                EntityKey ek = EntityKey.deserialize(ois, sfi);
                Object proxy = ois.readObject();
                if (proxy instanceof HibernateProxy) {
                    ((HibernateProxy)proxy).getHibernateLazyInitializer().setSession(session);
                    rtn.proxiesByKey.put(ek, proxy);
                    continue;
                }
                if (!tracing) continue;
                LOG.trace("Encountered pruned proxy");
            }
            count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] entitySnapshotsByKey entries");
            }
            rtn.entitySnapshotsByKey = new HashMap<EntityKey, Object>(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.entitySnapshotsByKey.put(EntityKey.deserialize(ois, sfi), ois.readObject());
            }
            rtn.entityEntryContext = EntityEntryContext.deserialize(ois, rtn);
            count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] collectionsByKey entries");
            }
            rtn.collectionsByKey = new HashMap<CollectionKey, PersistentCollection>(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.collectionsByKey.put(CollectionKey.deserialize(ois, session), (PersistentCollection)ois.readObject());
            }
            count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] collectionEntries entries");
            }
            rtn.collectionEntries = IdentityMap.instantiateSequenced(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                PersistentCollection pc = (PersistentCollection)ois.readObject();
                CollectionEntry ce = CollectionEntry.deserialize(ois, session);
                pc.setCurrentSession(session);
                rtn.collectionEntries.put(pc, ce);
            }
            count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] arrayHolders entries");
            }
            rtn.arrayHolders = new IdentityHashMap<Object, PersistentCollection>(count < 8 ? 8 : count);
            for (i = 0; i < count; ++i) {
                rtn.arrayHolders.put(ois.readObject(), (PersistentCollection)ois.readObject());
            }
            count = ois.readInt();
            if (tracing) {
                LOG.trace("Starting deserialization of [" + count + "] nullifiableEntityKey entries");
            }
            rtn.nullifiableEntityKeys = new HashSet();
            for (i = 0; i < count; ++i) {
                rtn.nullifiableEntityKeys.add(EntityKey.deserialize(ois, sfi));
            }
        }
        catch (HibernateException he) {
            throw new InvalidObjectException(he.getMessage());
        }
        return rtn;
    }

    @Override
    public void addChildParent(Object child, Object parent) {
        this.parentsByChild.put(child, parent);
    }

    @Override
    public void removeChildParent(Object child) {
        this.parentsByChild.remove(child);
    }

    @Override
    public void registerInsertedKey(EntityPersister persister, Serializable id) {
        if (persister.hasCache()) {
            String rootEntityName;
            List<Serializable> insertedEntityIds;
            if (this.insertedKeysMap == null) {
                this.insertedKeysMap = new HashMap();
            }
            if ((insertedEntityIds = this.insertedKeysMap.get(rootEntityName = persister.getRootEntityName())) == null) {
                insertedEntityIds = new ArrayList<Serializable>();
                this.insertedKeysMap.put(rootEntityName, insertedEntityIds);
            }
            insertedEntityIds.add(id);
        }
    }

    @Override
    public boolean wasInsertedDuringTransaction(EntityPersister persister, Serializable id) {
        List<Serializable> insertedEntityIds;
        if (persister.hasCache() && this.insertedKeysMap != null && (insertedEntityIds = this.insertedKeysMap.get(persister.getRootEntityName())) != null) {
            return insertedEntityIds.contains(id);
        }
        return false;
    }

    private void cleanUpInsertedKeysAfterTransaction() {
        if (this.insertedKeysMap != null) {
            this.insertedKeysMap.clear();
        }
    }

    @Override
    public PersistenceContext.NaturalIdHelper getNaturalIdHelper() {
        return this.naturalIdHelper;
    }

    private Object[] getNaturalIdValues(Object[] state, EntityPersister persister) {
        int[] naturalIdPropertyIndexes = persister.getNaturalIdentifierProperties();
        Object[] naturalIdValues = new Object[naturalIdPropertyIndexes.length];
        for (int i = 0; i < naturalIdPropertyIndexes.length; ++i) {
            naturalIdValues[i] = state[naturalIdPropertyIndexes[i]];
        }
        return naturalIdValues;
    }
}

