/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.UniqueKey;

public class DB2UniqueDelegate
extends DefaultUniqueDelegate {
    public DB2UniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        if (this.hasNullable(uniqueKey)) {
            return Index.buildSqlCreateIndexString(this.dialect, uniqueKey.getName(), uniqueKey.getTable(), uniqueKey.columnIterator(), uniqueKey.getColumnOrderMap(), true, defaultCatalog, defaultSchema);
        }
        return super.getAlterTableToAddUniqueKeyCommand(uniqueKey, defaultCatalog, defaultSchema);
    }

    public String getAlterTableToAddUniqueKeyCommand(org.hibernate.metamodel.relational.UniqueKey uniqueKey) {
        if (this.hasNullable(uniqueKey)) {
            return org.hibernate.metamodel.relational.Index.buildSqlCreateIndexString(this.dialect, uniqueKey.getName(), uniqueKey.getTable(), uniqueKey.getColumns(), true);
        }
        return super.getAlterTableToAddUniqueKeyCommand(uniqueKey);
    }

    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        if (this.hasNullable(uniqueKey)) {
            return Index.buildSqlDropIndexString(this.dialect, uniqueKey.getTable(), uniqueKey.getName(), defaultCatalog, defaultSchema);
        }
        return super.getAlterTableToDropUniqueKeyCommand(uniqueKey, defaultCatalog, defaultSchema);
    }

    public String getAlterTableToDropUniqueKeyCommand(org.hibernate.metamodel.relational.UniqueKey uniqueKey) {
        if (this.hasNullable(uniqueKey)) {
            return org.hibernate.metamodel.relational.Index.buildSqlDropIndexString(this.dialect, uniqueKey.getTable(), uniqueKey.getName());
        }
        return super.getAlterTableToDropUniqueKeyCommand(uniqueKey);
    }

    private boolean hasNullable(UniqueKey uniqueKey) {
        Iterator<Column> iter = uniqueKey.columnIterator();
        while (iter.hasNext()) {
            if (!iter.next().isNullable()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNullable(org.hibernate.metamodel.relational.UniqueKey uniqueKey) {
        for (org.hibernate.metamodel.relational.Column column : uniqueKey.getColumns()) {
            if (!column.isNullable()) continue;
            return true;
        }
        return false;
    }
}

