/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.internal.StatisticalLoggingSessionEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaselineSessionEventsListenerBuilder {
    private boolean logSessionMetrics;
    private Class<? extends SessionEventListener> autoListener;

    public BaselineSessionEventsListenerBuilder(boolean logSessionMetrics, Class<? extends SessionEventListener> autoListener) {
        this.logSessionMetrics = logSessionMetrics;
        this.autoListener = autoListener;
    }

    public boolean isLogSessionMetrics() {
        return this.logSessionMetrics;
    }

    public void setLogSessionMetrics(boolean logSessionMetrics) {
        this.logSessionMetrics = logSessionMetrics;
    }

    public Class<? extends SessionEventListener> getAutoListener() {
        return this.autoListener;
    }

    public void setAutoListener(Class<? extends SessionEventListener> autoListener) {
        this.autoListener = autoListener;
    }

    public List<SessionEventListener> buildBaselineList() {
        ArrayList<SessionEventListener> list = new ArrayList<SessionEventListener>();
        if (this.logSessionMetrics && StatisticalLoggingSessionEventListener.isLoggingEnabled()) {
            list.add(new StatisticalLoggingSessionEventListener());
        }
        if (this.autoListener != null) {
            try {
                list.add(this.autoListener.newInstance());
            }
            catch (Exception e) {
                throw new HibernateException("Unable to instantiate specified auto SessionEventListener : " + this.autoListener.getName(), e);
            }
        }
        return list;
    }
}

