/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.lang.reflect.Modifier;
import java.util.Set;
import org.hibernate.bytecode.buildtime.spi.ClassFilter;
import org.hibernate.bytecode.buildtime.spi.FieldFilter;
import org.hibernate.bytecode.instrumentation.internal.javassist.JavassistHelper;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.bytecode.internal.javassist.AccessOptimizerAdapter;
import org.hibernate.bytecode.internal.javassist.BulkAccessor;
import org.hibernate.bytecode.internal.javassist.BulkAccessorException;
import org.hibernate.bytecode.internal.javassist.FastClass;
import org.hibernate.bytecode.internal.javassist.FieldHandled;
import org.hibernate.bytecode.internal.javassist.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.internal.javassist.JavassistClassTransformer;
import org.hibernate.bytecode.internal.javassist.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.internal.javassist.ReflectionOptimizerImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ClassTransformer;
import org.hibernate.bytecode.spi.EntityInstrumentationMetadata;
import org.hibernate.bytecode.spi.NotInstrumentedException;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BytecodeProviderImpl.class.getName());

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        BulkAccessor bulkAccessor;
        FastClass fastClass;
        block8: {
            try {
                fastClass = FastClass.create(clazz);
                bulkAccessor = BulkAccessor.create(clazz, getterNames, setterNames, types);
                if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                    if (fastClass == null) {
                        bulkAccessor = null;
                    } else {
                        Object instance = fastClass.newInstance();
                        bulkAccessor.setPropertyValues(instance, bulkAccessor.getPropertyValues(instance));
                    }
                }
            }
            catch (Throwable t) {
                fastClass = null;
                bulkAccessor = null;
                if (!LOG.isDebugEnabled()) break block8;
                int index = 0;
                if (t instanceof BulkAccessorException) {
                    index = ((BulkAccessorException)t).getIndex();
                }
                if (index >= 0) {
                    LOG.debugf("Reflection optimizer disabled for %s [%s: %s (property %s)]", new Object[]{clazz.getName(), StringHelper.unqualify(t.getClass().getName()), t.getMessage(), setterNames[index]});
                }
                LOG.debugf("Reflection optimizer disabled for %s [%s: %s]", clazz.getName(), StringHelper.unqualify(t.getClass().getName()), t.getMessage());
            }
        }
        if (fastClass != null && bulkAccessor != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkAccessor, clazz));
        }
        return null;
    }

    public ClassTransformer getTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        return new JavassistClassTransformer(classFilter, fieldFilter);
    }

    public EntityInstrumentationMetadata getEntityInstrumentationMetadata(Class entityClass) {
        return new EntityInstrumentationMetadataImpl(entityClass);
    }

    private class EntityInstrumentationMetadataImpl
    implements EntityInstrumentationMetadata {
        private final Class entityClass;
        private final boolean isInstrumented;

        private EntityInstrumentationMetadataImpl(Class entityClass) {
            this.entityClass = entityClass;
            this.isInstrumented = FieldHandled.class.isAssignableFrom(entityClass);
        }

        public String getEntityName() {
            return this.entityClass.getName();
        }

        public boolean isInstrumented() {
            return this.isInstrumented;
        }

        public FieldInterceptor extractInterceptor(Object entity) throws NotInstrumentedException {
            if (!this.entityClass.isInstance(entity)) {
                throw new IllegalArgumentException(String.format("Passed entity instance [%s] is not of expected type [%s]", entity, this.getEntityName()));
            }
            if (!this.isInstrumented()) {
                throw new NotInstrumentedException(String.format("Entity class [%s] is not instrumented", this.getEntityName()));
            }
            return JavassistHelper.extractFieldInterceptor(entity);
        }

        public FieldInterceptor injectInterceptor(Object entity, String entityName, Set uninitializedFieldNames, SessionImplementor session) throws NotInstrumentedException {
            if (!this.entityClass.isInstance(entity)) {
                throw new IllegalArgumentException(String.format("Passed entity instance [%s] is not of expected type [%s]", entity, this.getEntityName()));
            }
            if (!this.isInstrumented()) {
                throw new NotInstrumentedException(String.format("Entity class [%s] is not instrumented", this.getEntityName()));
            }
            return JavassistHelper.injectFieldInterceptor(entity, entityName, uninitializedFieldNames, session);
        }
    }
}

