/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.jni;

import com.wibu.common.os.Arch;
import com.wibu.common.os.OsType;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public abstract class LibraryLoader {
    private OsType osType = OsType.getOsType();
    private Arch architecture = Arch.getCurrent();
    private boolean isLibraryLoaded = false;
    private String libraryNameOnError = "";
    private String libraryPathOnError = "";
    private UnsatisfiedLinkError firstException = null;

    public OsType getOsType() {
        return this.osType;
    }

    public Arch getArchitecture() {
        return this.architecture;
    }

    public boolean isLibraryLoaded() {
        return this.isLibraryLoaded;
    }

    protected void setOsType(OsType osType) {
        this.osType = osType;
    }

    protected void setArchitecture(Arch arch) {
        this.architecture = arch;
    }

    protected void setLibraryLoaded(boolean bl) {
        this.isLibraryLoaded = bl;
    }

    public boolean loadLibrary() throws LibraryLoaderException {
        this.isLibraryLoaded = this.loadLibraries(this.getLibraryNames(), this.getLibraryPaths());
        return this.isLibraryLoaded;
    }

    private boolean loadLibraries(List<String> list, List<String> list2) throws LibraryLoaderException {
        this.executePreAction();
        boolean bl = false;
        bl = this.checkUserLibrary(list, list2);
        if (!bl) {
            for (String string : list) {
                try {
                    System.loadLibrary(string);
                    bl = true;
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (this.firstException != null) continue;
                    this.firstException = unsatisfiedLinkError;
                    this.libraryNameOnError = System.mapLibraryName(string);
                }
            }
        }
        if (bl) {
            this.executePostAction();
            return true;
        }
        if (this.firstException != null) {
            throw new LibraryLoaderException(this.firstException, this.libraryNameOnError, this.libraryPathOnError);
        }
        return false;
    }

    private boolean checkUserLibrary(List<String> list, List<String> list2) {
        for (String string : list2) {
            this.log("Native library path is '" + string + "'.");
            for (String string2 : list) {
                for (String string3 : this.mapLibraryName(string2)) {
                    try {
                        File file = new File(string, string3);
                        System.load(file.getAbsolutePath());
                        this.log("Loaded native library " + string2 + " from " + string);
                        return true;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (this.firstException != null) continue;
                        this.firstException = unsatisfiedLinkError;
                        this.libraryNameOnError = string3;
                        this.libraryPathOnError = string;
                    }
                }
            }
        }
        return false;
    }

    protected List<String> mapLibraryName(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.osType.equals((Object)OsType.Mac)) {
            linkedList.add("lib" + string + ".dylib");
            linkedList.add("lib" + string + ".jnilib");
        } else {
            linkedList.add(System.mapLibraryName(string));
        }
        return linkedList;
    }

    protected List<String> getLibraryNames() {
        String string = this.getBaseName();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.getOsType() == OsType.Windows) {
            linkedList.add(string + this.getArchitecture().getBits());
        }
        if (this.getOsType().equals((Object)OsType.Linux)) {
            string = string.toLowerCase();
            if (this.getArchitecture().is64Bit()) {
                linkedList.add(string + this.getArchitecture().getBits());
            }
        }
        linkedList.add(string);
        return linkedList;
    }

    protected void log(String string) {
        System.out.println(string);
    }

    protected void executePreAction() {
    }

    protected void executePostAction() {
    }

    protected abstract List<String> getLibraryPaths();

    protected abstract String getBaseName();

    public static class LibraryLoaderException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private UnsatisfiedLinkError error;
        private String libraryName;
        private String libraryPath;

        public LibraryLoaderException(UnsatisfiedLinkError unsatisfiedLinkError, String string, String string2) {
            this.error = unsatisfiedLinkError;
            this.libraryName = string;
            this.libraryPath = string2;
        }

        public UnsatisfiedLinkError getError() {
            return this.error;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public String getStrippedLibraryName() {
            String string = this.libraryName;
            if (string.startsWith("lib")) {
                string = string.replaceFirst("lib", "");
            }
            if (string.contains(".")) {
                string = string.substring(0, string.indexOf("."));
            }
            return string;
        }

        public String getLibraryPath() {
            return this.libraryPath;
        }
    }
}

