/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.storage.configuration;

import de.bscgmbh.sn.config.forms.GenericConfigurationFormField;
import de.bscgmbh.sn.storage.StorageContent;
import de.bscgmbh.sn.storage.configuration.IStorageProviderConfiguration;
import de.bscgmbh.sn.storage.provider.IStorageProviderImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public class StorageProviderConfiguration
implements IStorageProviderConfiguration {
    protected String id;
    protected IStorageProviderImpl storageProvider;
    protected Set<StorageContent> selectedStorageContent;
    protected ArrayList<GenericConfigurationFormField> configuration;
    protected boolean enabled = true;
    protected String customName;
    protected boolean deletable = true;
    protected int maxBackupCount = 0;

    protected StorageProviderConfiguration() {
    }

    protected StorageProviderConfiguration(IStorageProviderConfiguration configuration) {
        this.id = configuration.getId();
        this.storageProvider = configuration.getStorageProvider();
        this.selectedStorageContent = configuration.getSelectedStorageContent();
        this.configuration = configuration.getConfiguration();
        this.enabled = configuration.isEnabled();
        this.customName = configuration.getCustomName();
        this.deletable = configuration.isDeletable();
        this.maxBackupCount = configuration.getMaxBackupCount();
    }

    public StorageProviderConfiguration(String id, IStorageProviderImpl storageProvider, ArrayList<GenericConfigurationFormField> configuration) {
        this.id = id;
        this.storageProvider = storageProvider;
        this.configuration = configuration;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ArrayList<GenericConfigurationFormField> getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        return this.configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setConfiguration(ArrayList<GenericConfigurationFormField> configuration) {
        this.configuration = configuration;
    }

    @Override
    public IStorageProviderImpl getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProvider(IStorageProviderImpl storageProvider) {
        this.storageProvider = storageProvider;
    }

    @Override
    public Set<StorageContent> getSelectedStorageContent() {
        if (this.selectedStorageContent == null) {
            this.selectedStorageContent = EnumSet.noneOf(StorageContent.class);
        }
        return this.selectedStorageContent;
    }

    @Override
    public void setSelectedStorageContent(Set<StorageContent> selectedStorageContent) {
        this.selectedStorageContent = selectedStorageContent;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getCustomName() {
        return this.customName == null ? this.id : this.customName;
    }

    @Override
    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String toString() {
        return "StorageProviderConfiguration [id=" + this.id + ", storageProvider=" + this.storageProvider + ", selectedStorageContent=" + this.selectedStorageContent + ", configuration=" + this.configuration + ", enabled=" + this.enabled + ", customName=" + this.customName + ", deletable=" + this.deletable + ", maxBackupCount=" + this.maxBackupCount + "]";
    }

    @Override
    public Map<String, String> getParameterMap() {
        return this.storageProvider.getParameterMap(this);
    }

    @Override
    public boolean isStorageAvailable() {
        return this.storageProvider.isStorageAvailable(this);
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    @Override
    public int getMaxBackupCount() {
        return this.maxBackupCount;
    }

    public void setMaxBackupCount(int maxBackupCount) {
        this.maxBackupCount = maxBackupCount;
    }

    public static StorageProviderConfiguration applyDeleteProtection(StorageProviderConfiguration configuration) {
        configuration.deletable = false;
        return configuration;
    }
}

