/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.storage;

import de.bscgmbh.sn.storage.configuration.FileStorageProviderConfiguration;
import de.bscgmbh.sn.storage.provider.IStorageListEntry;
import de.bscgmbh.sn.storage.provider.StorageContentFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum StorageContent {
    BACKUP("backup", ".backup"),
    RECOVERY("recovery", ".cpio"),
    UPDATES("updates", ".upd"),
    PCT14("pct14", ".pct"),
    MISC("misc", new String[0]);

    private final Set<String> fileExtensions;
    private final String contentDirectory;

    private StorageContent(String contentDirectory, String ... fileExtensions) {
        this.contentDirectory = contentDirectory;
        this.fileExtensions = new HashSet<String>();
        if (fileExtensions != null) {
            for (String extension : fileExtensions) {
                this.fileExtensions.add(extension);
            }
        }
    }

    public Set<String> getFileExtensions() {
        return Collections.unmodifiableSet(this.fileExtensions);
    }

    public String getContentDirectory() {
        return this.contentDirectory;
    }

    public static StorageContent getStorageContentByFileName(String filename) {
        for (StorageContent storageContent : StorageContent.values()) {
            for (String extension : storageContent.getFileExtensions()) {
                if (!filename.endsWith(extension)) continue;
                return storageContent;
            }
        }
        return MISC;
    }

    public static StorageContentFile[] searchForContentFiles(FileStorageProviderConfiguration config) {
        ArrayList<StorageContentFile> result = new ArrayList<StorageContentFile>();
        for (StorageContent contentType : StorageContent.values()) {
            IStorageListEntry[] entries = config.listFiles(contentType.getContentDirectory());
            if (entries == null) continue;
            for (IStorageListEntry entry : entries) {
                result.add(new StorageContentFile(config.getId(), entry.getName(), entry.getSize(), entry.getModTime()));
            }
        }
        return result.toArray(new StorageContentFile[result.size()]);
    }
}

