/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JPanel;

public class MJPG
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -7659799357789085163L;
    public boolean useMJPGStream = true;
    public boolean connected = false;
    private boolean initCompleted = false;
    public String jpgURL;
    public String mjpgURL;
    private String username;
    private String password;
    private String base64authorization = null;
    private Image image = null;
    public Dimension imageSize = null;
    DataInputStream dis;
    HttpURLConnection huc = null;

    public MJPG(String[] Daten) {
        this.mjpgURL = "http://" + Daten[0] + "/videostream.cgi";
        this.jpgURL = "http://" + Daten[0] + "/videostream.cgi";
        this.username = Daten[4];
        this.password = Daten[1];
        if (this.username == null || this.password == null) {
            System.out.println("Kein Benutzer angegeben!");
        } else {
            this.base64authorization = this.encodeUsernameAndPasswordInBase64(this.username, this.password);
        }
    }

    private String encodeUsernameAndPasswordInBase64(String usern, String psswd) {
        String s = String.valueOf(usern) + ":" + psswd;
        return "Basic ";
    }

    public void connect() {
        try {
            URL u = new URL(this.useMJPGStream ? this.mjpgURL : this.jpgURL);
            this.huc = (HttpURLConnection)u.openConnection();
            if (this.base64authorization != null) {
                this.huc.setDoInput(true);
                this.huc.setRequestProperty("Authorization", this.base64authorization);
                this.huc.connect();
            }
            InputStream is = this.huc.getInputStream();
            this.connected = true;
            BufferedInputStream bis = new BufferedInputStream(is);
            this.dis = new DataInputStream(bis);
            if (!this.initCompleted) {
                this.initDisplay();
            }
        }
        catch (IOException e) {
            try {
                this.huc.disconnect();
                Thread.sleep(60L);
            }
            catch (InterruptedException ie) {
                this.huc.disconnect();
                this.connect();
            }
            this.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initDisplay() {
        if (this.useMJPGStream) {
            this.readMJPGStream();
        } else {
            this.readJPG();
            this.disconnect();
        }
        this.imageSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        this.setPreferredSize(this.imageSize);
        this.initCompleted = true;
    }

    public void disconnect() {
        try {
            if (this.connected) {
                this.dis.close();
                this.connected = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        }
    }

    public void readStream() {
        try {
            if (this.useMJPGStream) {
                while (true) {
                    this.readMJPGStream();
                    this.repaint();
                }
            }
            while (true) {
                this.connect();
                this.readJPG();
                this.repaint();
                this.disconnect();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void readMJPGStream() {
        this.readLine(4, this.dis);
        this.readJPG();
        this.readLine(1, this.dis);
    }

    public void readJPG() {
    }

    public void readLine(int n, DataInputStream dis) {
        int i = 0;
        while (i < n) {
            this.readLine(dis);
            ++i;
        }
    }

    public void readLine(DataInputStream dis) {
        try {
            boolean end = false;
            String lineEnd = "\n";
            byte[] lineEndBytes = lineEnd.getBytes();
            byte[] byteBuf = new byte[lineEndBytes.length];
            while (!end) {
                dis.read(byteBuf, 0, lineEndBytes.length);
                String t = new String(byteBuf);
                if (!t.equals(lineEnd)) continue;
                end = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.connect();
        this.readStream();
    }

    public Image getImage() {
        return this.image;
    }
}

