/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class ElementalReverseProxy {
    private static final String HTTP_IN_CONN = "http.proxy.in-conn";
    private static final String HTTP_OUT_CONN = "http.proxy.out-conn";
    private static final String HTTP_CONN_KEEPALIVE = "http.proxy.conn-keepalive";

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Please specified target hostname and port");
            System.exit(1);
        }
        String hostname = args[0];
        int port = 80;
        if (args.length > 1) {
            port = Integer.parseInt(args[1]);
        }
        HttpHost target = new HttpHost(hostname, port);
        RequestListenerThread t = new RequestListenerThread(8888, target);
        t.setDaemon(false);
        t.start();
    }

    static class ProxyHandler
    implements HttpRequestHandler {
        private final HttpHost target;
        private final HttpProcessor httpproc;
        private final HttpRequestExecutor httpexecutor;
        private final ConnectionReuseStrategy connStrategy;

        public ProxyHandler(HttpHost target, HttpProcessor httpproc, HttpRequestExecutor httpexecutor) {
            this.target = target;
            this.httpproc = httpproc;
            this.httpexecutor = httpexecutor;
            this.connStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpClientConnection conn = (HttpClientConnection)context.getAttribute(ElementalReverseProxy.HTTP_OUT_CONN);
            context.setAttribute("http.connection", (Object)conn);
            context.setAttribute("http.target_host", (Object)this.target);
            System.out.println(">> Request URI: " + request.getRequestLine().getUri());
            request.removeHeaders("Content-Length");
            request.removeHeaders("Transfer-Encoding");
            request.removeHeaders("Connection");
            request.removeHeaders("Keep-Alive");
            request.removeHeaders("Proxy-Authenticate");
            request.removeHeaders("TE");
            request.removeHeaders("Trailers");
            request.removeHeaders("Upgrade");
            this.httpexecutor.preProcess(request, this.httpproc, context);
            HttpResponse targetResponse = this.httpexecutor.execute(request, conn, context);
            this.httpexecutor.postProcess(response, this.httpproc, context);
            targetResponse.removeHeaders("Content-Length");
            targetResponse.removeHeaders("Transfer-Encoding");
            targetResponse.removeHeaders("Connection");
            targetResponse.removeHeaders("Keep-Alive");
            targetResponse.removeHeaders("TE");
            targetResponse.removeHeaders("Trailers");
            targetResponse.removeHeaders("Upgrade");
            response.setStatusLine(targetResponse.getStatusLine());
            response.setHeaders(targetResponse.getAllHeaders());
            response.setEntity(targetResponse.getEntity());
            System.out.println("<< Response: " + response.getStatusLine());
            boolean keepalive = this.connStrategy.keepAlive(response, context);
            context.setAttribute(ElementalReverseProxy.HTTP_CONN_KEEPALIVE, (Object)new Boolean(keepalive));
        }
    }

    static class ProxyThread
    extends Thread {
        private final HttpService httpservice;
        private final HttpServerConnection inconn;
        private final HttpClientConnection outconn;

        public ProxyThread(HttpService httpservice, HttpServerConnection inconn, HttpClientConnection outconn) {
            this.httpservice = httpservice;
            this.inconn = inconn;
            this.outconn = outconn;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            System.out.println("New connection thread");
            BasicHttpContext context = new BasicHttpContext(null);
            context.setAttribute(ElementalReverseProxy.HTTP_IN_CONN, (Object)this.inconn);
            context.setAttribute(ElementalReverseProxy.HTTP_OUT_CONN, (Object)this.outconn);
            try {
                try {
                    while (!Thread.interrupted()) {
                        if (!this.inconn.isOpen()) {
                            this.outconn.close();
                        } else {
                            this.httpservice.handleRequest(this.inconn, (HttpContext)context);
                            Boolean keepalive = (Boolean)context.getAttribute(ElementalReverseProxy.HTTP_CONN_KEEPALIVE);
                            if (Boolean.TRUE.equals(keepalive)) continue;
                            this.outconn.close();
                            this.inconn.close();
                        }
                        break;
                    }
                }
                catch (ConnectionClosedException ex) {
                    System.err.println("Client closed connection");
                    try {
                        this.inconn.shutdown();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.outconn.shutdown();
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException ex) {
                    System.err.println("I/O error: " + ex.getMessage());
                    try {
                        this.inconn.shutdown();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.outconn.shutdown();
                    }
                    catch (IOException iOException) {}
                }
                catch (HttpException ex) {
                    System.err.println("Unrecoverable HTTP protocol violation: " + ex.getMessage());
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        this.inconn.shutdown();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.outconn.shutdown();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    this.inconn.shutdown();
                }
                catch (IOException iOException) {}
                try {
                    this.outconn.shutdown();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static class RequestListenerThread
    extends Thread {
        private final HttpHost target;
        private final ServerSocket serversocket;
        private final HttpService httpService;

        public RequestListenerThread(int port, HttpHost target) throws IOException {
            this.target = target;
            this.serversocket = new ServerSocket(port);
            ImmutableHttpProcessor inhttpproc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent("Test/1.1"), new RequestExpectContinue(true)});
            ImmutableHttpProcessor outhttpproc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer("Test/1.1"), new ResponseContent(), new ResponseConnControl()});
            HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
            UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
            reqistry.register("*", (HttpRequestHandler)new ProxyHandler(this.target, (HttpProcessor)outhttpproc, httpexecutor));
            this.httpService = new HttpService((HttpProcessor)inhttpproc, (HttpRequestHandlerMapper)reqistry);
        }

        @Override
        public void run() {
            System.out.println("Listening on port " + this.serversocket.getLocalPort());
            while (!Thread.interrupted()) {
                try {
                    int bufsize = 8192;
                    Socket insocket = this.serversocket.accept();
                    DefaultBHttpServerConnection inconn = new DefaultBHttpServerConnection(8192);
                    System.out.println("Incoming connection from " + insocket.getInetAddress());
                    inconn.bind(insocket);
                    Socket outsocket = new Socket(this.target.getHostName(), this.target.getPort());
                    DefaultBHttpClientConnection outconn = new DefaultBHttpClientConnection(8192);
                    outconn.bind(outsocket);
                    System.out.println("Outgoing connection to " + outsocket.getInetAddress());
                    ProxyThread t = new ProxyThread(this.httpService, (HttpServerConnection)inconn, (HttpClientConnection)outconn);
                    t.setDaemon(true);
                    t.start();
                }
                catch (InterruptedIOException ex) {
                    break;
                }
                catch (IOException e) {
                    System.err.println("I/O error initialising connection thread: " + e.getMessage());
                    break;
                }
            }
        }
    }
}

