/*
 * Decompiled with CFR 0.152.
 */
package storage;

import database.CameraObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import storage.connection.SettingsConnection;

public class SettingStorage {
    private static SettingsConnection settingsConnection;
    public static final String FILE_SEPARATOR;
    private static final String DIR = "data";
    private static final String CONFIG = "config";
    private static final String FILE_SETTINGS = "set.dat";
    private static final String FILE_CAMERA = "cam.dat";
    public static boolean USE_LOCAL_STORAGE;
    private static List<CameraObject> cameraObjectList;

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        USE_LOCAL_STORAGE = true;
        cameraObjectList = new ArrayList<CameraObject>();
    }

    public static SettingsConnection getSettingsConnection() {
        if (settingsConnection == null && (settingsConnection = SettingStorage.readSettingsConnection()) == null) {
            settingsConnection = new SettingsConnection("user", "test", "0.0.0.0", "test", "test");
        }
        return settingsConnection;
    }

    public static List<CameraObject> readCameraObjectList() {
        cameraObjectList = new ArrayList<CameraObject>();
        File file = new File(String.valueOf(SettingStorage.getAbsoluteConfigPath()) + FILE_SEPARATOR + FILE_CAMERA);
        if (file.exists()) {
            FileInputStream fin = null;
            ObjectInputStream oin = null;
            try {
                fin = new FileInputStream(file);
                oin = new ObjectInputStream(fin);
                CameraObject obj = null;
                int zaehler = 1;
                while ((obj = (CameraObject)oin.readObject()) != null) {
                    cameraObjectList.add(obj);
                    ++zaehler;
                }
                oin.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cameraObjectList;
    }

    private static SettingsConnection readSettingsConnection() {
        File file = new File(String.valueOf(SettingStorage.getAbsoluteConfigPath()) + FILE_SEPARATOR + FILE_SETTINGS);
        if (file.exists()) {
            FileInputStream fin = null;
            ObjectInputStream oin = null;
            try {
                fin = new FileInputStream(file);
                oin = new ObjectInputStream(fin);
                SettingsConnection sc = (SettingsConnection)oin.readObject();
                oin.close();
                return sc;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void writeSettings() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(String.valueOf(SettingStorage.getAbsoluteConfigPath()) + FILE_SEPARATOR + FILE_SETTINGS);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(settingsConnection);
            oos.flush();
            fos.close();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveSettings(String user, String password, String ip, String motionUser, String motionPwd) {
        if (settingsConnection == null) {
            settingsConnection = new SettingsConnection(user, password, ip, motionUser, motionPwd);
        } else {
            settingsConnection.setUserName(user);
            settingsConnection.setPassword(password);
            settingsConnection.setIpStation(ip);
            settingsConnection.setMotionUser(motionUser);
            settingsConnection.setMotionPasssword(motionPwd);
        }
        SettingStorage.writeSettings();
    }

    public static void main(String[] args) {
        try {
            String test = new File(SettingStorage.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).toString();
            System.out.println(test);
            File file = new File(".");
            file = new File(String.valueOf(file.getCanonicalPath()) + FILE_SEPARATOR + CONFIG);
            System.out.println("file " + file.getAbsolutePath());
            URL url = SettingStorage.class.getResource(file.getAbsolutePath());
            System.out.println("was ist " + url.toExternalForm());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getAbsoluteConfigPath() {
        String stringPath = null;
        try {
            if (USE_LOCAL_STORAGE) {
                stringPath = new File(SettingStorage.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).toString();
                if (stringPath.contains("bin")) {
                    stringPath = stringPath.replace("bin", "");
                }
                if (stringPath.contains(".jar")) {
                    stringPath = stringPath.replace(".jar", "");
                }
                System.out.println("ergebnis ist<" + stringPath + ">");
            } else {
                File fileTest = new File(".");
                stringPath = new File(String.valueOf(fileTest.getCanonicalPath()) + FILE_SEPARATOR + CONFIG).getAbsolutePath();
            }
            File file = new File(String.valueOf(stringPath) + FILE_SEPARATOR + DIR);
            if (!file.exists()) {
                file.mkdirs();
            }
            System.out.println("direct>> " + file.getAbsolutePath());
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void saveCameraObjectList(List<CameraObject> tempList) {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(String.valueOf(SettingStorage.getAbsoluteConfigPath()) + FILE_SEPARATOR + FILE_CAMERA);
            oos = new ObjectOutputStream(fos);
            int i = 0;
            while (i < tempList.size()) {
                oos.writeObject(tempList.get(i));
                oos.flush();
                ++i;
            }
            oos.writeObject(null);
            oos.flush();
            fos.close();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearSettingsConnection() {
        settingsConnection = null;
    }
}

