/*
 * Decompiled with CFR 0.152.
 */
package response.syno.surveillancestation.camera;

import connect.Connection;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import request.syno.helper.CAMERA_ID;
import response.Response;
import response.helper.ResponseContainer;
import response.statuscode.surveillancestation.camera.StatusCamera;

public class MJPEGResponse
extends Response<StatusCamera, BufferedImage> {
    private static final long serialVersionUID = 1435636762833444721L;
    private BufferedImage responseImage = null;
    private CAMERA_ID cameraID;

    public ResponseContainer<StatusCamera, BufferedImage> handleResponse(HttpResponse response) {
        HttpEntity entity;
        int status = response.getStatusLine().getStatusCode();
        StatusCamera enumStatus = StatusCamera.getErrorCode(status);
        BufferedImage bi = null;
        if (enumStatus == StatusCamera.STATUS_200 && (entity = response.getEntity()) != null) {
            Object temp = null;
            try {
                InputStream is = entity.getContent();
                bi = ImageIO.read(is);
            }
            catch (IOException | ParseException throwable) {
                // empty catch block
            }
        }
        return new ResponseContainer<StatusCamera, Object>(enumStatus, bi);
    }

    @Override
    public Response<StatusCamera, BufferedImage> setHttpResponse(HttpResponse httpResponse) {
        Object responseContainer = this.handleResponse(httpResponse);
        Connection.fireIAPIMessage(((StatusCamera)((Object)((ResponseContainer)responseContainer).getStatusCode())).getStatusCode(), "Image Anforderung");
        if (((ResponseContainer)responseContainer).getStatusCode() == StatusCamera.STATUS_200) {
            this.responseImage = (BufferedImage)((ResponseContainer)responseContainer).getAnswerValue();
        }
        return this;
    }

    @Override
    protected Response<StatusCamera, BufferedImage> setValuesWithOwnParser(Response responseObject, String body) {
        return null;
    }

    @Override
    protected boolean useOwnParser() {
        return false;
    }

    public BufferedImage getImage() {
        return this.responseImage;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.responseImage = bufferedImage;
    }

    public void setCameraID(CAMERA_ID cameraID) {
        this.cameraID = cameraID;
    }

    public int getRawCameraId() {
        if (this.cameraID != null) {
            return this.cameraID.getRawCameraId();
        }
        return 0;
    }
}

