/*
 * Decompiled with CFR 0.152.
 */
package connect.motion;

import connect.Connection;
import database.CameraObject;
import java.util.ArrayList;
import java.util.List;
import motion.IMotionServiceAPIConnect;
import storage.SettingStorage;
import storage.connection.SettingsConnection;

public class MotionServiceAPIConnect
implements IMotionServiceAPIConnect {
    private String user = "test";
    private String pwd = "test";
    private List<String> activeMotionEndpoints = new ArrayList<String>();

    public boolean isUserPWDAuthorized(String decodedUser, String decodedPwd) {
        return decodedUser != null && decodedUser.equals(this.user) && decodedPwd != null && decodedUser.equals(this.pwd);
    }

    public void doMotionDetection(String endpointValue) {
        if (endpointValue == null || endpointValue.length() <= 0) {
            return;
        }
        List<CameraObject> gespeicherteKameras = SettingStorage.readCameraObjectList();
        if (gespeicherteKameras != null && gespeicherteKameras.size() > 0) {
            int i = 0;
            while (i < gespeicherteKameras.size()) {
                if (gespeicherteKameras.get(i).getEntryPointMotionDetection().equals(endpointValue)) {
                    if (this.activeMotionEndpoints.contains(endpointValue)) {
                        Connection.fireIMotion(endpointValue);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public void registerEndpoint(String endpointValue) {
        if (!this.activeMotionEndpoints.contains(endpointValue)) {
            this.activeMotionEndpoints.add(endpointValue);
        }
    }

    public void deRegisterEndpoint(String endpointValue) {
        if (this.activeMotionEndpoints.contains(endpointValue)) {
            this.activeMotionEndpoints.remove(endpointValue);
        }
    }

    public void readSettings() {
        SettingsConnection settingsConnection = SettingStorage.getSettingsConnection();
        this.user = settingsConnection.getMotionUser();
        this.pwd = settingsConnection.getMotionPasssword();
    }
}

