/*
 * Decompiled with CFR 0.152.
 */
package connect.mjpeg.test.dritterVersuch;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

public class MJPEGStream3
extends DataInputStream {
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private final byte[] EOI_MARKER = new byte[]{-1, -39};
    private final String CONTENT_LENGTH = "Content-Length".toLowerCase();
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 100100;
    private boolean open = true;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MJPEGStream3(InputStream in) {
        super(new BufferedInputStream(in, 100100));
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        long startTime = System.currentTimeMillis();
        int s = 0;
        int zaehler = 0;
        int laengerAls100ms = 0;
        boolean first = false;
        int i = 0;
        while (i < 100100) {
            long start1 = System.currentTimeMillis();
            byte c = (byte)in.readUnsignedByte();
            long ende2 = System.currentTimeMillis();
            if (ende2 - start1 > 100L) {
                ++laengerAls100ms;
            }
            System.out.println("gefunden erstes ELement " + i);
            if (c == sequence[s]) {
                if (++s == sequence.length) {
                    System.out.println("gefunden zweites ELement " + i);
                    long endTime = System.currentTimeMillis();
                    return i + 1;
                }
            } else {
                s = 0;
            }
            ++zaehler;
            ++i;
        }
        System.out.println("gebe minus 1  zur\u00fcck");
        return -1;
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        long startTime = System.currentTimeMillis();
        int end = this.getEndOfSeqeunce(in, sequence);
        long endTime = System.currentTimeMillis();
        System.out.println("endseq in ms: " + (endTime - startTime));
        return end < 0 ? -1 : end - sequence.length;
    }

    public static void main(String[] args) {
        String CONTENT_LENGTH = "Content-Length";
        String test = "Content-Type: image/jpeg Content-Length: 30114";
        int index = test.indexOf(CONTENT_LENGTH);
        System.out.println("index " + index);
        test = test.substring(index);
        System.out.println(test);
        String[] splitValue = test.split(": ");
        System.out.println(splitValue[1]);
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, NumberFormatException {
        System.out.println("headerBytes laenge " + headerBytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (!line.toLowerCase().startsWith(this.CONTENT_LENGTH) || (parts = line.split(":")).length != 2) continue;
            int valueToReturn = Integer.parseInt(parts[1].trim());
            return valueToReturn;
        }
        return 0;
    }

    public BufferedImage readFrame() throws IOException {
        if (!this.open) {
            return null;
        }
        byte[] header = null;
        byte[] frame = null;
        this.mark(100100);
        long startTime = System.currentTimeMillis();
        int n = this.getStartOfSequence(this, this.SOI_MARKER);
        long ende = System.currentTimeMillis();
        System.out.println("Bildlese-Dauer in ms:" + (ende - startTime));
        System.out.println("n " + n);
        this.reset();
        header = new byte[n];
        this.readFully(header);
        int length = -1;
        try {
            length = this.parseContentLength(header);
            System.out.println("laengeNachParsed Header " + length);
        }
        catch (NumberFormatException e) {
            length = this.getEndOfSeqeunce(this, this.EOI_MARKER);
            System.out.println("laengeNachEOI " + length);
        }
        System.out.println("header toHex " + MJPEGStream3.toHexString(header));
        System.out.println("header clear " + new String(header));
        System.out.println("header size " + header.length);
        if (length == 0) {
            System.out.println("Invalid MJPEG stream, EOI (0xFF,0xD9) not found!");
        }
        this.reset();
        System.out.println("lenght " + length);
        frame = new byte[length];
        this.skipBytes(n);
        this.readFully(frame);
        System.out.println("frame " + frame.length);
        try {
            return ImageIO.read(new ByteArrayInputStream(frame));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return new String();
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            buffer.append(MJPEGStream3.toHexString(data[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static String toHexString(byte value) {
        char[] chars = new char[]{digits[value >>> 4 & 0xF], digits[value & 0xF]};
        return new String(chars);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        super.close();
    }

    public boolean isClosed() {
        return !this.open;
    }
}

