/*
 * Decompiled with CFR 0.152.
 */
package connect.mjpeg.test;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MJPEGParser
implements Callable<ConnectionStateEnum> {
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 100100;
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private static final byte[] JPEG_START = new byte[]{-1, -40};
    private static final int INITIAL_BUFFER_SIZE = 4096;
    final InputStream in;
    byte[] boundary;
    byte[] segment;
    byte[] buf;
    int cur;
    int len;
    boolean canceled = false;
    final BlockingQueue<byte[]> imageQueue;
    final int maxBytesPerImage;

    public MJPEGParser(InputStream in, String boundary, BlockingQueue<byte[]> imageQueue, int maxBytesPerImage) {
        this.in = Objects.requireNonNull(in);
        this.boundary = Objects.requireNonNull(boundary).getBytes();
        this.imageQueue = Objects.requireNonNull(imageQueue);
        this.maxBytesPerImage = maxBytesPerImage;
        this.buf = new byte[4096];
        this.cur = 0;
        this.len = 4096;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    protected void processSegment() throws IOException {
        boolean found = false;
        int i = 0;
        while (i < this.cur - JPEG_START.length) {
            if (this.segmentsEqual(this.buf, i, JPEG_START, 0, JPEG_START.length)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            System.out.println("boundary >  " + this.boundary.length);
            System.out.println("cur >  " + this.cur);
            int segLength = this.cur - this.boundary.length - i;
            System.out.println("segmentLaenge " + segLength);
            this.segment = new byte[segLength];
            System.arraycopy(this.buf, i, this.segment, 0, segLength);
            if (this.segment != null) {
                this.imageQueue.offer(Arrays.copyOf(this.segment, this.segment.length));
            }
        }
    }

    private byte[] getSegment() {
        return this.segment;
    }

    private boolean segmentsEqual(byte[] b1, int b1Start, byte[] b2, int b2Start, int len) {
        if (b1Start < 0 || b2Start < 0 || b1Start + len > b1.length || b2Start + len > b2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (b1[b1Start + i] != b2[b2Start + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkBoundary() {
        return this.segmentsEqual(this.buf, this.cur - this.boundary.length, this.boundary, 0, this.boundary.length);
    }

    public int getBufferSize() {
        return this.len;
    }

    private void append(int i) {
        if (this.cur >= this.len) {
            this.buf = Arrays.copyOf(this.buf, this.len * 2);
            this.len *= 2;
        }
        this.buf[this.cur++] = (byte)i;
    }

    @Override
    public ConnectionStateEnum call() throws InterruptedException {
        int byteCounter = 0;
        try {
            int b;
            while ((b = this.in.read()) != -1 && !this.canceled && !Thread.currentThread().isInterrupted()) {
                this.append(b);
                if (++byteCounter >= this.maxBytesPerImage) {
                    this.buf = new byte[4096];
                    this.cur = 0;
                    byteCounter = 0;
                }
                if (!this.checkBoundary()) continue;
                this.processSegment();
                this.cur = 0;
                byteCounter = 0;
            }
            System.out.println("bin drau\u00dfen");
        }
        catch (IOException e) {
            return ConnectionStateEnum.IO_ERROR;
        }
        if (this.canceled) {
            return ConnectionStateEnum.CANCELLED;
        }
        return ConnectionStateEnum.OK;
    }

    public static byte[] parseOneImage(InputStream in, String boundary, int maxBytesPerImage, long waitingTime, TimeUnit timeunit) {
        ExecutorService service = Executors.newSingleThreadExecutor();
        LinkedBlockingQueue<byte[]> imageQueue = new LinkedBlockingQueue<byte[]>(1);
        MJPEGParser mjpegParser = new MJPEGParser(in, boundary, imageQueue, maxBytesPerImage);
        Future<ConnectionStateEnum> future = service.submit(mjpegParser);
        try {
            byte[] image = (byte[])imageQueue.poll(waitingTime, timeunit);
            System.out.println("image " + image.length);
            if (image != null) {
                future.cancel(true);
                byte[] byArray = image;
                return byArray;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            future.cancel(true);
            service.shutdown();
        }
        return null;
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        long startTime = System.currentTimeMillis();
        int s = 0;
        byte c = 0;
        int zaehler = 0;
        int laengerAls100ms = 0;
        int i = 0;
        while (i < 100100 || c == -1) {
            long start1 = System.currentTimeMillis();
            c = (byte)in.readUnsignedByte();
            long ende2 = System.currentTimeMillis();
            if (ende2 - start1 > 100L) {
                ++laengerAls100ms;
            }
            if (c == sequence[s]) {
                if (++s == sequence.length) {
                    long endTime = System.currentTimeMillis();
                    System.out.println("readUnsigne " + (endTime - startTime));
                    System.out.println("durchlauf wie oft " + zaehler);
                    System.out.println("readUnsigne laenger als 100ms count " + laengerAls100ms);
                    return i + 1;
                }
            } else {
                s = 0;
            }
            ++zaehler;
            System.out.println("weiter gehts");
            ++i;
        }
        System.out.println("gebe minus 1  zur\u00fcck");
        return -1;
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        int end = this.getEndOfSeqeunce(in, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    public static enum ConnectionStateEnum {
        OK,
        IO_ERROR,
        CANCELLED,
        TIMEOUT;

    }
}

