/*
 * Decompiled with CFR 0.152.
 */
package connect.mjpeg;

import connect.Connection;
import connect.interfaces.IMotionThread;
import connect.mjpeg.MJPEGStream;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import request.syno.helper.CAMERA_ID;
import response.syno.surveillancestation.camera.MJPEGResponse;

public class MJPEGThread
extends Thread
implements IMotionThread {
    private MJPEGStream meg = null;
    private CAMERA_ID cameraID;
    private boolean running = false;
    private InputStream in;
    private String boundary;

    public MJPEGThread(InputStream in, CAMERA_ID cameraID, String boundary) {
        this.boundary = boundary;
        this.meg = new MJPEGStream(in);
        this.cameraID = cameraID;
        this.running = true;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(10L);
                BufferedImage image = this.meg.readFrame();
                if (image == null) continue;
                MJPEGResponse snapshot = new MJPEGResponse();
                snapshot.setCameraID(this.cameraID);
                snapshot.setImage(image);
                Connection.fireIObject(snapshot);
            }
            catch (Exception e) {
                this.running = false;
                e.printStackTrace();
            }
        }
        try {
            this.running = false;
            this.meg.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void stopThread() {
        this.running = false;
    }
}

