/*
 * Decompiled with CFR 0.152.
 */
package connect.mjpeg;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

public class MJPEGStream
extends DataInputStream {
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private final byte[] EOI_MARKER = new byte[]{-1, -39};
    private final String CONTENT_LENGTH = "Content-Length".toLowerCase();
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 100100;
    private boolean open = true;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MJPEGStream(InputStream in) {
        super(new BufferedInputStream(in, 100100));
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        int s = 0;
        int i = 0;
        while (i < 100100) {
            byte c = (byte)in.readUnsignedByte();
            if (c == sequence[s]) {
                if (++s == sequence.length) {
                    return i + 1;
                }
            } else {
                s = 0;
            }
            ++i;
        }
        return -1;
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        int end = this.getEndOfSeqeunce(in, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, NumberFormatException {
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (!line.toLowerCase().startsWith(this.CONTENT_LENGTH) || (parts = line.split(":")).length != 2) continue;
            int valueToReturn = Integer.parseInt(parts[1].trim());
            return valueToReturn;
        }
        return 0;
    }

    public BufferedImage readFrame() throws IOException {
        if (!this.open) {
            return null;
        }
        byte[] header = null;
        byte[] frame = null;
        this.mark(100100);
        int n = this.getStartOfSequence(this, this.SOI_MARKER);
        this.reset();
        header = new byte[n];
        this.readFully(header);
        int length = -1;
        try {
            length = this.parseContentLength(header);
        }
        catch (NumberFormatException e) {
            length = this.getEndOfSeqeunce(this, this.EOI_MARKER);
        }
        if (length == 0) {
            System.out.println("Invalid MJPEG stream, EOI (0xFF,0xD9) not found!");
        }
        this.reset();
        frame = new byte[length];
        this.skipBytes(n);
        this.readFully(frame);
        try {
            return ImageIO.read(new ByteArrayInputStream(frame));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return new String();
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            buffer.append(MJPEGStream.toHexString(data[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static String toHexString(byte value) {
        char[] chars = new char[]{digits[value >>> 4 & 0xF], digits[value & 0xF]};
        return new String(chars);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        super.close();
    }

    public boolean isClosed() {
        return !this.open;
    }
}

