/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import java.io.Serializable;
import java.util.Arrays;

public class Version
implements Serializable {
    private static final long serialVersionUID = -509760128811977079L;
    protected int msMajorVersion = 10;
    protected int msMinorVersion = 0;
    protected int msBuild = 2597;
    protected int msCount = 500;
    protected int msYear = 2017;
    protected int msMonth = 4;
    protected int msDay = 3;
    private String[] months = new String[]{"0", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public Version() {
    }

    public Version(int sMajorVersion, int sMinorVersion, int sBuild, int sCount, int sYear, int sMonth, int sDay) {
        this.set(sMajorVersion, sMinorVersion, sBuild, sCount, sYear, sMonth, sDay);
    }

    public void set(int sMajorVersion, int sMinorVersion, int sBuild, int sCount, int sYear, int sMonth, int sDay) {
        this.msMajorVersion = sMajorVersion;
        this.msMinorVersion = sMinorVersion;
        this.msBuild = sBuild;
        this.msCount = sCount;
        this.msYear = sYear;
        this.msMonth = sMonth;
        this.msDay = sDay;
    }

    public String toString() {
        String strVersion = this.getVersion() + this.getBuild() + " of " + this.getDate(this.getMsYear(), this.getMsMonth(), this.getMsDay());
        return strVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.msBuild != other.msBuild) {
            return false;
        }
        if (this.msMajorVersion != other.msMajorVersion) {
            return false;
        }
        return this.msMinorVersion == other.msMinorVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.months);
        result = 31 * result + this.msBuild;
        result = 31 * result + this.msCount;
        result = 31 * result + this.msDay;
        result = 31 * result + this.msMajorVersion;
        result = 31 * result + this.msMinorVersion;
        result = 31 * result + this.msMonth;
        result = 31 * result + this.msYear;
        return result;
    }

    public String getVersion() {
        String strVersion = Integer.toString(this.msMajorVersion) + (this.msMinorVersion < 10 ? ".0" : ".") + Integer.toString(this.msMinorVersion);
        if (this.msCount > 500 && this.msCount < 526) {
            strVersion = strVersion + String.valueOf(this.msCount - 501);
            strVersion = strVersion + Character.toString('a');
        }
        return strVersion;
    }

    public String getBuild() {
        String strBuild = "";
        switch (this.msCount / 100) {
            case 5: {
                break;
            }
            case 3: {
                strBuild = strBuild + "Gamma (Level " + Integer.toString(this.msCount - 300) + ")";
                break;
            }
            case 2: {
                strBuild = strBuild + "Beta (Level " + Integer.toString(this.msCount - 200) + ")";
                break;
            }
            case 1: {
                strBuild = strBuild + "Alpha (Level " + Integer.toString(this.msCount - 100) + ")";
                break;
            }
            default: {
                strBuild = strBuild + "." + Integer.toString(this.msCount - 100);
            }
        }
        strBuild = strBuild + " Build " + Integer.toString(this.msBuild);
        return strBuild;
    }

    private String getDate(int year, int month, int day) {
        return String.format("%1$04d-%2$3s-%3$02d", year, this.months[month], day);
    }

    public String getDate() {
        String strDate = this.getDate(this.msYear, this.msMonth, this.msDay);
        return strDate;
    }

    public String getCopyRight() {
        String strCopyRight = "Copyright (c) 2005-" + Integer.toString(this.msYear) + " by WIBU-SYSTEMS AG. All rights reserved.";
        return strCopyRight;
    }

    public boolean isNewerThan(int major, int minor, int build) {
        if (this.getMsMajorVersion() < major) {
            return false;
        }
        if (this.getMsMajorVersion() > major) {
            return true;
        }
        if (this.getMsMinorVersion() < minor) {
            return false;
        }
        if (this.getMsMinorVersion() > minor) {
            return true;
        }
        return this.getMsBuild() >= build;
    }

    public int getMsMajorVersion() {
        return this.msMajorVersion;
    }

    public int getMsMinorVersion() {
        return this.msMinorVersion;
    }

    public int getMsBuild() {
        return this.msBuild;
    }

    public int getMsCount() {
        return this.msCount;
    }

    public int getMsYear() {
        return this.msYear;
    }

    public int getMsMonth() {
        return this.msMonth;
    }

    public int getMsDay() {
        return this.msDay;
    }
}

