/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.MessageHandler;
import com.wibu.xpm.ProgressWindow;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SwingMessageHandler
extends MessageHandler {
    protected static final String kwindowtitle = "WIBU-SYSTEMS Software Protection";
    protected ProgressWindow progress = null;
    protected JFrame frame = null;
    protected int lastProgress = 0;

    @Override
    public void init(Properties props) {
        super.init(props);
    }

    @Override
    protected void printMessage(String strFormat, String strData) {
        Object[] args = new Object[]{new String(strData)};
        String strMessage = MessageFormat.format(strFormat, args);
        JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 1);
    }

    @Override
    public int warningExpirationTime(String daysLeft, String time) {
        String strFormat = this.mprops.getProperty("WarningExpirationTime");
        if (strFormat == null) {
            strFormat = "The license will expire soon. Remaining days: {0}.";
        }
        Object[] args = new Object[]{new String(daysLeft)};
        String strMessage = MessageFormat.format(strFormat, args);
        JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 2);
        return 0;
    }

    @Override
    public int warningUnitCounter(String unitCounterValue, int value) {
        String strFormat = this.mprops.getProperty("WarningUnitCounter");
        if (strFormat == null) {
            strFormat = "Unit Counter reached {0}.";
        }
        Object[] args = new Object[]{new String(unitCounterValue)};
        String strMessage = MessageFormat.format(strFormat, args);
        JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 2);
        return 0;
    }

    @Override
    public int warningUsagePeriodActivation(int periodInHours) {
        Object[] options;
        int nStatus;
        String strMessage = this.mprops.getProperty("WarningUsagePeriodActivation");
        if (strMessage == null) {
            strMessage = "Usage Period will be activated if application is continued.";
        }
        if (1 == (nStatus = JOptionPane.showOptionDialog(null, strMessage, kwindowtitle, 0, 0, null, options = new Object[]{"Continue", "Abort"}, options[0]))) {
            System.exit(1);
        }
        return 0;
    }

    @Override
    public int warningCertifiedTime(int difference) {
        String strFormat = this.mprops.getProperty("WarningCertifiedTime");
        if (strFormat == null) {
            strFormat = "Warning: Out of CmContainer Certified Time in near future.";
        }
        Object[] args = new Object[]{new String(Integer.toString(difference))};
        String strMessage = MessageFormat.format(strFormat, args);
        JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 2);
        return 0;
    }

    @Override
    public int errorExpirationTime(String strLicense) {
        String strFormat = this.mprops.getProperty("ErrorExpirationTime");
        if (strFormat == null) {
            strFormat = "{0}: Entry expired.";
        }
        Object[] args = new Object[]{new String(strLicense)};
        String strMessage = MessageFormat.format(strFormat, args);
        JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 0);
        System.exit(1);
        return 0;
    }

    @Override
    public int errorUnitCounter(String strLicense) {
        String strFormat = this.mprops.getProperty("ErrorUnitCounter");
        if (strFormat == null) {
            strFormat = "{0}: Unit counter empty.";
        }
        Object[] args = new Object[]{new String(strLicense)};
        String strMessage = MessageFormat.format(strFormat, args);
        JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 0);
        System.exit(1);
        return 0;
    }

    @Override
    public int errorUnspecified(String strError) {
        JOptionPane.showMessageDialog(null, "Error: " + strError, kwindowtitle, 0);
        return 0;
    }

    @Override
    public int errorSubsystemNotFound(String strLicense) {
        String strFormat = this.mprops.getProperty("ErrorSubsystemNotFound");
        if (strFormat == null) {
            strFormat = "{0}: Subsystem not found.";
        }
        Object[] args = new Object[]{new String(strLicense)};
        String strMessage = MessageFormat.format(strFormat, args);
        JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 0);
        System.exit(1);
        return 0;
    }

    @Override
    public int errorNoLicense(String requiredLicenses, String details, int retries) {
        String strFormat = this.mprops.getProperty("ErrorNoLicense");
        if (strFormat == null) {
            strFormat = "One of the following licenses is required:\n{0}";
        }
        Object[] args = new Object[]{new String(requiredLicenses)};
        String strMessage = MessageFormat.format(strFormat, args);
        Object[] options = new Object[]{"Retry", "Abort"};
        int nStatus = JOptionPane.showOptionDialog(null, strMessage, kwindowtitle, 0, 0, null, options, options[0]);
        if (1 == nStatus) {
            System.exit(1);
        }
        return 0;
    }

    @Override
    public int errorRuntimeCheck(String strRequiredLicenses, String strDetails, int ignores) {
        int nStatus;
        String strFormat = this.mprops.getProperty("ErrorNoLicense");
        if (strFormat == null) {
            strFormat = "Copy Protection Error:\n{0}";
        }
        Object[] args = new Object[]{new String(strRequiredLicenses)};
        String strMessage = MessageFormat.format(strFormat, args);
        if (0 == ignores) {
            Object[] options = new Object[]{"Retry", "Abort"};
            nStatus = JOptionPane.showOptionDialog(null, strMessage, kwindowtitle, 0, 0, null, options, options[0]);
            if (1 == nStatus) {
                System.exit(1);
            }
        } else {
            Object[] options = new Object[]{"Retry", "Ignore", "Abort"};
            nStatus = JOptionPane.showOptionDialog(null, strMessage, kwindowtitle, 0, 0, null, options, options[0]);
            if (2 == nStatus) {
                System.exit(1);
            }
        }
        return nStatus;
    }

    @Override
    public int errorUnknownVm(String strDetails) {
        try {
            Class<?> clazz = Class.forName("com.wibu.xpm.UpdateSignature");
            Runnable updateSignature = (Runnable)clazz.newInstance();
            updateSignature.run();
        }
        catch (Exception e) {
            Object[] args = new Object[]{new String(e.getMessage())};
            String strMessage = MessageFormat.format("Unknown error {0}", args);
            JOptionPane.showMessageDialog(null, strMessage, kwindowtitle, 0);
        }
        return 0;
    }

    @Override
    public boolean prefetchClass(int index, int numberOfClasses, String className) {
        if (0 == index) {
            this.frame = new JFrame();
            this.frame.setTitle(kwindowtitle);
            this.frame.setLocationByPlatform(true);
            ProgressWindow newContentPane = this.progress = new ProgressWindow();
            newContentPane.setOpaque(true);
            this.frame.setContentPane(newContentPane);
            this.frame.pack();
            this.frame.setVisible(true);
            this.progress.start("Prefetching classes:\n");
        } else if (index == numberOfClasses - 1) {
            this.progress = null;
            this.frame.dispose();
            this.frame = null;
        } else {
            int newProgress = 100 * index / numberOfClasses;
            if (newProgress != this.lastProgress) {
                this.lastProgress = newProgress;
                this.progress.QD9LPCNXpo(index, className + "\n");
            }
        }
        return true;
    }
}

