/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import java.text.MessageFormat;
import java.util.Properties;

public class MessageHandler {
    protected Properties mprops = null;

    protected MessageHandler() {
    }

    public void init(Properties props) {
        this.mprops = props;
    }

    public void messageBoot() {
        String strMessage = this.mprops.getProperty("MessageBoot");
        if (strMessage != null) {
            this.printMessage(strMessage, "");
        }
    }

    public void messageStart() {
        String strMessage = this.mprops.getProperty("MessageStart");
        if (strMessage != null) {
            this.printMessage(strMessage, "");
        }
    }

    public int warningExpirationTime(String daysLeft, String time) {
        String strMessage = this.mprops.getProperty("WarningExpirationTime");
        if (strMessage == null) {
            strMessage = "Warning: The license will expire soon. Remaining days:\n{0}";
        }
        this.printMessage(strMessage, daysLeft);
        return 0;
    }

    public int warningUnitCounter(String unitCounterValue, int value) {
        String strMessage = this.mprops.getProperty("WarningUnitCounter");
        if (strMessage == null) {
            strMessage = "Warning: Unit Counter reached {0}.";
        }
        this.printMessage(strMessage, unitCounterValue);
        return 0;
    }

    public int warningUsagePeriodActivation(int periodInHours) {
        String strMessage = this.mprops.getProperty("WarningUsagePeriodActivation");
        if (strMessage != null) {
            this.printMessage(strMessage, null);
        }
        return 0;
    }

    public int warningCertifiedTime(int difference) {
        String strFormat = this.mprops.getProperty("WarningCertifiedTime");
        if (strFormat == null) {
            strFormat = "Warning: Out of CmContainer Certified Time in near future.";
        }
        this.printMessage(strFormat, "");
        return 0;
    }

    public int errorNoLicense(String requiredLicenses, String details, int retries) {
        String strFormat = this.mprops.getProperty("ErrorNoLicense");
        if (strFormat == null) {
            strFormat = "Copy Protection Error: None of the following Licenses are available:\n{0}";
        }
        this.printMessage(strFormat, requiredLicenses);
        System.exit(1);
        return 1;
    }

    public int errorRuntimeCheck(String strRequiredLicenses, String strDetails, int ignores) {
        String strFormat = this.mprops.getProperty("ErrorNoLicense");
        if (strFormat == null) {
            strFormat = "Copy Protection Error:\n{0}";
        }
        this.printMessage(strFormat, strRequiredLicenses);
        if (0 == ignores) {
            System.exit(1);
        }
        return 1;
    }

    public int errorExpirationTime(String strLicense) {
        String strMessage = this.mprops.getProperty("ErrorExpirationTime");
        if (strMessage == null) {
            strMessage = "Error: Entry expired!";
        }
        this.printMessage(strMessage, strLicense);
        System.exit(1);
        return 0;
    }

    public int errorUnitCounter(String strLicense) {
        String strMessage = this.mprops.getProperty("ErrorUnitCounter");
        if (strMessage == null) {
            strMessage = "Error: Unit counter empty!";
        }
        this.printMessage(strMessage, strLicense);
        System.exit(1);
        return 0;
    }

    public int errorUnspecified(String strMessage) {
        this.printMessage("Error: " + strMessage, "");
        System.exit(1);
        return 0;
    }

    public int errorSubsystemNotFound(String strLicense) {
        String strMessage = this.mprops.getProperty("ErrorSubsystemNotFound");
        if (strMessage == null) {
            strMessage = "Error: Subsystem not found!";
        }
        this.printMessage(strMessage, strLicense);
        System.exit(1);
        return 0;
    }

    public int errorUnknownVm(String strDetails) {
        this.printMessage("Unknown VM found.", strDetails);
        return 0;
    }

    protected void printMessage(String strFormat, String strData) {
        Object[] args = new Object[]{strData};
        String strMessage = MessageFormat.format(strFormat, args);
        strMessage = strMessage.replace("\\n", System.lineSeparator()).replace("\\r", System.lineSeparator()).replace("\\t", "\t").replace("\\b", "\b");
        System.err.println(strMessage);
    }

    public boolean prefetchClass(int index, int numberOfClasses, String className) {
        if (0 == index) {
            System.out.print("Prefetching classes .");
        } else if (index == numberOfClasses - 1) {
            System.out.println(". done.");
        } else {
            System.out.print(".");
        }
        return true;
    }
}

