/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import java.util.logging.Level;

public class Logger {
    protected boolean mfRuntime;
    private static Logger mpInstanceRuntime = null;
    private static Logger mpInstanceAxProtector = null;
    protected java.util.logging.Logger mLogger;

    private Logger(boolean fRuntime) {
        this.mfRuntime = fRuntime;
        try {
            if (this.mfRuntime) {
                this.mLogger = java.util.logging.Logger.getLogger("com.wibu.xpm.Runtime");
                if (this.mLogger != null && this.mLogger.getLevel() == null) {
                    this.mLogger.setLevel(Level.OFF);
                }
            } else {
                this.mLogger = java.util.logging.Logger.getLogger("com.wibu.xpm.AxProtector");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == this.mLogger) {
            System.err.println("Logger could not be created.");
        }
    }

    public static Logger getLogger(boolean fRuntime) {
        if (fRuntime) {
            if (null == mpInstanceRuntime) {
                mpInstanceRuntime = new Logger(fRuntime);
            }
            return mpInstanceRuntime;
        }
        if (null == mpInstanceAxProtector) {
            mpInstanceAxProtector = new Logger(fRuntime);
        }
        return mpInstanceAxProtector;
    }

    public void debug(String strMsg) {
        this.mLogger.finest(strMsg);
    }

    public void trace(String strMsg) {
        this.mLogger.finer(strMsg);
    }

    public void fine(String strMsg) {
        this.mLogger.fine(strMsg);
    }

    public void info(String strMsg) {
        if (this.mfRuntime) {
            this.mLogger.info(strMsg);
        } else {
            System.out.println("Info: " + strMsg);
        }
    }

    public void warning(String strMsg) {
        if (this.mfRuntime) {
            this.mLogger.warning(strMsg);
        } else {
            System.err.println("Warning: " + strMsg);
        }
    }

    public void error(String strMsg) {
        if (this.mfRuntime) {
            this.mLogger.severe(strMsg);
        } else {
            System.err.println("Error: " + strMsg);
        }
    }

    public void fatal(String strMsg) {
        if (this.mfRuntime) {
            this.mLogger.severe(strMsg);
        } else {
            System.err.println("Fatal: " + strMsg);
        }
    }

    public int getLevel() {
        Level level = this.mLogger.getLevel();
        if (null == level) {
            java.util.logging.Logger parent = this.mLogger.getParent();
            if (parent == null) {
                return Level.OFF.intValue();
            }
            level = parent.getLevel();
            if (null == level) {
                return Level.OFF.intValue();
            }
        }
        return level.intValue();
    }

    public static void main(String[] args) {
        Logger.printLevel(Level.ALL);
        Logger.printLevel(Level.CONFIG);
        Logger.printLevel(Level.FINE);
        Logger.printLevel(Level.FINER);
        Logger.printLevel(Level.FINEST);
        Logger.printLevel(Level.INFO);
        Logger.printLevel(Level.OFF);
        Logger.printLevel(Level.SEVERE);
        Logger.printLevel(Level.WARNING);
    }

    private static void printLevel(Level level) {
        System.out.println(level.getName() + " - " + level.intValue());
    }

    public void setLevel(Level level) {
        this.mLogger.setLevel(level);
    }

    public boolean isLoggable(Level warning) {
        return this.mLogger.isLoggable(warning);
    }

    public static void cleanUp() {
        mpInstanceRuntime = null;
        mpInstanceAxProtector = null;
    }
}

