/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.tools.pdfcreator.attachment;

import de.bscgmbh.tools.pdfcreator.attachment.IAttachment;
import de.bscgmbh.tools.pdfcreator.attachment.form.AFormField;
import de.bscgmbh.tools.pdfcreator.attachment.form.CheckboxFormField;
import de.bscgmbh.tools.pdfcreator.attachment.form.TextFormField;
import java.util.ArrayList;

public class PdfFormAttachment
implements IAttachment {
    protected String documentFile = null;
    protected ArrayList<AFormField> formValues = null;

    protected PdfFormAttachment() {
    }

    public PdfFormAttachment(String documentFile) {
        this.documentFile = documentFile;
    }

    public PdfFormAttachment(String documentFile, AFormField ... values) {
        this.documentFile = documentFile;
        if (values != null) {
            for (AFormField formField : values) {
                this.getFormValues().add(formField);
            }
        }
    }

    @Override
    public IAttachment.AttachmentType getType() {
        return IAttachment.AttachmentType.FORM;
    }

    public String getDocumentFile() {
        return this.documentFile;
    }

    public void setDocumentFile(String documentFile) {
        this.documentFile = documentFile;
    }

    public ArrayList<AFormField> getFormValues() {
        if (this.formValues == null) {
            this.formValues = new ArrayList();
        }
        return this.formValues;
    }

    public void setFormValues(ArrayList<AFormField> formValues) {
        this.formValues = formValues;
    }

    public PdfFormAttachment addFormField(AFormField formField) {
        this.getFormValues().add(formField);
        return this;
    }

    public PdfFormAttachment addFormCheckboxField(String name, boolean checked) {
        return this.addFormField(new CheckboxFormField(name, checked));
    }

    public PdfFormAttachment addFormTextField(String name, String value) {
        return this.addFormField(new TextFormField(name, value));
    }
}

