/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.tools.pdfcreator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.bscgmbh.tools.pdfcreator.AttachmentAppender;
import de.bscgmbh.tools.pdfcreator.attachment.IAttachment;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFCreator {
    protected Logger logger = LoggerFactory.getLogger(PDFCreator.class);
    protected static ObjectMapper objectMapper = null;
    protected String outFile = null;
    protected ArrayList<IAttachment> attachments = null;
    protected PDDocument document = null;
    protected AttachmentAppender attachmentAppender = null;

    protected PDFCreator() {
    }

    public PDFCreator(String outFile) {
        this(outFile, null);
    }

    public PDFCreator(String outFile, ArrayList<IAttachment> attachments) {
        this.outFile = outFile;
        this.attachments = attachments;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public ArrayList<IAttachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        return this.attachments;
    }

    public void setAttachments(ArrayList<IAttachment> attachments) {
        this.attachments = attachments;
    }

    @Transient
    public AttachmentAppender getAttachmentAppender() {
        if (this.attachmentAppender == null) {
            this.attachmentAppender = AttachmentAppender.createDefaultInstance();
        }
        return this.attachmentAppender;
    }

    public void setAttachmentAppender(AttachmentAppender attachmentAppender) {
        this.attachmentAppender = attachmentAppender;
    }

    public PDFCreator appendAttachment(IAttachment attachment) {
        if (attachment != null) {
            this.getAttachments().add(attachment);
        }
        return this;
    }

    public void create() throws IOException {
        if (this.outFile != null) {
            this.document = new PDDocument();
            AttachmentAppender appender = this.getAttachmentAppender();
            for (IAttachment iAttachment : this.getAttachments()) {
                appender.appendAttachment(this.document, iAttachment);
            }
            this.document.save(new File(this.outFile));
            this.document.close();
        }
    }

    public void export(String toFile) {
        try {
            PDFCreator.exportToJsonFile(toFile, new PDFCreator[]{this});
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected static ObjectMapper getObjectMapperInstance() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_NULL).enableDefaultTyping();
        }
        return objectMapper;
    }

    public static PDFCreator[] importFromJson(String file) throws JsonParseException, JsonMappingException, IOException {
        return (PDFCreator[])PDFCreator.getObjectMapperInstance().readValue(new File(file), PDFCreator[].class);
    }

    public static void exportToJsonFile(String file, PDFCreator[] jobs) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectWriter writer = PDFCreator.getObjectMapperInstance().writer((PrettyPrinter)new DefaultPrettyPrinter());
        writer.writeValue(new File(file), (Object)jobs);
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        ArrayList<PDFCreator> tasks = new ArrayList<PDFCreator>();
        for (String file : args) {
            if (!new File(file).isFile()) continue;
            PDFCreator[] jobImport = null;
            try {
                jobImport = PDFCreator.importFromJson(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (jobImport == null) continue;
            for (PDFCreator pdfCreator : jobImport) {
                tasks.add(pdfCreator);
            }
        }
        System.out.println("Execute " + tasks.size() + " task(s)...");
        for (PDFCreator pdfCreator : tasks) {
            System.out.println(pdfCreator.outFile + " with " + pdfCreator.getAttachments().size() + " attachments.");
            try {
                pdfCreator.create();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Finished after " + (System.currentTimeMillis() - start) + "ms!");
    }
}

