/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.config.modules.system.files;

import de.bscgmbh.sn.config.modules.system.files.SharedFolderPermission;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SharedFolder
extends File {
    private static final long serialVersionUID = 2678251606549103884L;
    private final String displayName;
    private final Set<SharedFolderPermission> permissions;

    public SharedFolder(String displayName, String pathname, Set<SharedFolderPermission> permissions) {
        super(pathname);
        this.permissions = Objects.requireNonNull(Collections.unmodifiableSet(permissions), "permissions must not be null!");
        this.displayName = Objects.requireNonNull(displayName, "name must not be null!");
    }

    public Set<SharedFolderPermission> getPermissions() {
        return this.permissions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SharedFolderPermission sharedFolderPermission : this.permissions) {
            if (sb.length() != 0) {
                sb.append(" | ");
            }
            sb.append(sharedFolderPermission.name());
        }
        return "SharedFolder [displayName=" + this.displayName + ", permissions=" + sb.toString() + "]";
    }
}

