/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.config.modules;

public class SoftwareVersion
implements Comparable<SoftwareVersion> {
    protected int major = -1;
    protected int minor = -1;
    protected int patch = -1;

    protected SoftwareVersion() {
    }

    public SoftwareVersion(String version) {
        this.parseVersionString(version);
    }

    protected boolean parseVersionString(String versionString) {
        if (versionString != null) {
            String[] vParts = versionString.trim().replace("-SNAPSHOT", "").split("\\.");
            if (vParts.length == 3) {
                try {
                    this.major = Integer.valueOf(vParts[0]);
                    this.minor = Integer.valueOf(vParts[1]);
                    this.patch = Integer.valueOf(vParts[2]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public SoftwareVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean isValid() {
        return this.major >= 0 && this.minor >= 0 && this.patch >= 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoftwareVersion other = (SoftwareVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    public String toString() {
        return SoftwareVersion.convertToString(this);
    }

    public String getVersionString() {
        return SoftwareVersion.convertToString(this);
    }

    public static String convertToString(SoftwareVersion softwareVersion) {
        return softwareVersion.getMajor() + "." + softwareVersion.getMinor() + "." + softwareVersion.getPatch();
    }

    public static SoftwareVersion getInstance(int major, int minor, int patch) {
        return new SoftwareVersion(major, minor, patch);
    }

    @Override
    public int compareTo(SoftwareVersion arg0) {
        int result = new Integer(this.major).compareTo(arg0.getMajor());
        if (result == 0) {
            result = new Integer(this.minor).compareTo(arg0.getMinor());
        }
        if (result == 0) {
            result = new Integer(this.patch).compareTo(arg0.getPatch());
        }
        return result;
    }
}

