/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.tools.creator;

import bsc.sdk.tools.creator.AObjectCreator;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenJ9Creator
extends AObjectCreator {
    private static Logger logger = LoggerFactory.getLogger(OpenJ9Creator.class);

    @Override
    public <T> T newInstance(Class<T> c) throws Exception {
        return null;
    }

    @Override
    public Class<?>[] getClasses(String packageName, boolean subPackages) {
        String path = packageName.replace('.', '/');
        URL resource = this.classLoader.getResource(path);
        ArrayList classes = new ArrayList();
        if (resource != null) {
            ArrayList<File> dirs = new ArrayList<File>();
            ArrayList<URL> urls = new ArrayList<URL>();
            if (!resource.toString().contains("!")) {
                dirs.add(new File(resource.getFile()));
            } else {
                urls.add(resource);
            }
            for (File directory : dirs) {
                try {
                    classes.addAll(this.findClasses(directory, packageName, subPackages));
                }
                catch (ClassNotFoundException e) {}
            }
            for (URL url : urls) {
                classes.addAll(this.findClasses(url, packageName, subPackages));
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private List<Class<?>> findClasses(File directory, String packageName, boolean subPackages) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory() && subPackages) {
                assert (!file.getName().contains("."));
                classes.addAll(this.findClasses(file, packageName + "." + file.getName(), subPackages));
                continue;
            }
            if (!file.getName().contains(".class")) continue;
            String name = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            if (name.startsWith(".")) {
                name = name.substring(1);
            }
            if (name.contains("$")) continue;
            try {
                classes.add(this.getClassForName(name));
            }
            catch (Throwable e) {
                logger.error("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage(), e);
            }
        }
        return classes;
    }

    private List<Class<?>> findClasses(URL url, String packageName, boolean subPackages) {
        packageName = packageName.replace('.', '/');
        JarURLConnection connection = null;
        ArrayList classes = new ArrayList();
        try {
            connection = (JarURLConnection)url.openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                int index;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(packageName) || !name.contains(".class") || !subPackages && !packageName.equals(name.substring(0, index = name.lastIndexOf("/")))) continue;
                name = name.substring(0, name.indexOf(46));
                if ((name = name.replace('/', '.')).contains("$")) continue;
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(name));
                }
                catch (Throwable e) {
                    logger.error("Exception: " + e.getClass().getName() + ", Message: " + e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return classes;
    }
}

