/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.tools.creator;

import bsc.sdk.tools.JarContentManifest;
import bsc.sdk.tools.creator.AAndroidCreator;
import bsc.sdk.tools.creator.IOSObjectCreator;
import bsc.sdk.tools.creator.JVMObjectCreator;
import bsc.sdk.tools.creator.OpenJ9Creator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AObjectCreator {
    protected final ClassLoader classLoader;
    private static Logger logger = LoggerFactory.getLogger(AObjectCreator.class);
    protected List<String> allJavaSources = new ArrayList<String>();
    private static List<String> customJavaSources = new ArrayList<String>();

    public abstract <T> T newInstance(Class<T> var1) throws Exception;

    protected AObjectCreator() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        assert (this.classLoader != null);
        try {
            this.fillJavaSources();
        }
        catch (Exception e) {
            logger.error("Error loading SDK resource list", (Throwable)e);
        }
    }

    public static int addCustomJavaSources(List<String> javaSources) {
        if (javaSources == null) {
            return customJavaSources.size();
        }
        for (String source : javaSources) {
            customJavaSources.add(source);
        }
        return customJavaSources.size();
    }

    public Class<?> getClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public <T> T deepClone(T object) {
        Object result = null;
        if (object != null && object instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                result = ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
                logger.error("Deep clone crashed with " + object.getClass().getName());
            }
        }
        return (T)result;
    }

    public Class<?>[] getClasses(String packageName, boolean subPackages) {
        String path = packageName.replace('.', '/');
        ArrayList classes = new ArrayList();
        for (String line : this.allJavaSources) {
            String start = line;
            if (!start.startsWith(path)) continue;
            String rest = start.substring(start.indexOf(path) + path.length());
            if (rest.startsWith("/")) {
                rest = rest.substring(1);
            }
            String className = "";
            try {
                Class<?> clazz;
                className = start.replace('/', '.').substring(0, start.lastIndexOf("."));
                if (className.contains("$")) continue;
                if (rest.contains("/") && subPackages) {
                    clazz = this.classLoader.loadClass(className);
                    classes.add(clazz);
                    System.out.println("Class added sucessfully: " + className);
                }
                if (rest.contains("/")) continue;
                clazz = this.classLoader.loadClass(className);
                classes.add(clazz);
                System.out.println("Class added successfully: " + className);
            }
            catch (Exception e) {
                System.out.println("Error during class loading: " + className + ", " + e.getClass().getName());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        System.out.println("returning " + classes.size() + " built classes");
        return classes.toArray(new Class[classes.size()]);
    }

    private final void fillJavaSources() throws IOException {
        this.allJavaSources = JarContentManifest.getJarContent();
        System.out.println("JarManifest: " + this.allJavaSources.size() + " classes found.");
        for (String customSource : customJavaSources) {
            this.allJavaSources.add(customSource);
        }
        System.out.println("Expanded JarManifest with: " + customJavaSources.size() + " classes.");
        System.out.println("JarManifest now has: " + this.allJavaSources.size() + " classes");
    }

    public static AObjectCreator create(String packageCodePath) {
        try {
            if (packageCodePath != null) {
                System.out.println("packageCodePath<" + packageCodePath + ">");
                if (packageCodePath.contains("Oracle") || packageCodePath.contains("Private Build")) {
                    return new JVMObjectCreator();
                }
                if (packageCodePath.contains("Eclipse OpenJ9") || packageCodePath.contains("AdoptOpenJDK")) {
                    return new OpenJ9Creator();
                }
                if (packageCodePath.contains("RoboVM")) {
                    return new IOSObjectCreator();
                }
                if (packageCodePath.contains("apk")) {
                    return AAndroidCreator.createAndroid(packageCodePath);
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new AObjectCreator(){

            @Override
            public <T> T newInstance(Class<T> c) {
                throw new UnsupportedOperationException("Unable to create an object of class " + c);
            }

            @Override
            public Class<?>[] getClasses(String packageName, boolean subPackages) {
                throw new IllegalArgumentException("Unable to get classes of UNKNOWN platform.");
            }
        };
    }
}

