/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.tools.creator;

import bsc.sdk.tools.creator.AObjectCreator;
import bsc.sdk.tools.creator.AndroidPostGingerBreadObjectCreator;
import bsc.sdk.tools.creator.AndroidPostGingerBreadResourcesObjectCreator;
import bsc.sdk.tools.creator.AndroidPostNougatObjectCreator;
import bsc.sdk.tools.creator.AndroidPostNougatResourcesObjectCreator;
import bsc.sdk.tools.creator.AndroidPreGingerBreadObjectCreator;
import bsc.sdk.tools.creator.AndroidPreGingerBreadResourcesObjectCreator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AAndroidCreator {
    private static boolean useCreatedFilesList = true;
    private static Logger logger = LoggerFactory.getLogger(AAndroidCreator.class);
    private int sdk;

    private AAndroidCreator() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        Class<?> version = classLoader.loadClass("android.os.Build$VERSION");
        Field sdkInt = version.getField("SDK_INT");
        this.sdk = (Integer)sdkInt.get(null);
    }

    public static AObjectCreator createAndroid(String packageCodePath) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IOException {
        logger.debug("Create AndroidObjectCreator");
        if (new AAndroidCreator().sdk < 9) {
            if (useCreatedFilesList) {
                logger.debug("Using Pre Gingerbread (Resource List)");
                return new AndroidPreGingerBreadResourcesObjectCreator();
            }
            logger.debug("Using Pre Gingerbread (Original)");
            return new AndroidPreGingerBreadObjectCreator(packageCodePath);
        }
        if (new AAndroidCreator().sdk >= 24) {
            if (useCreatedFilesList) {
                logger.debug("Using Post Nougat (Resource List)");
                return new AndroidPostNougatResourcesObjectCreator();
            }
            logger.debug("Using Post Nougat (Original)");
            return new AndroidPostNougatObjectCreator(packageCodePath);
        }
        if (useCreatedFilesList) {
            logger.debug("Using Post Gingerbread (Resource List)");
            return new AndroidPostGingerBreadResourcesObjectCreator();
        }
        logger.debug("Using Post Gingerbread (Original)");
        return new AndroidPostGingerBreadObjectCreator(packageCodePath);
    }
}

