/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SimpleFileWriter {
    private BufferedWriter bw;
    private static final String EXTENSION = ".txt";
    private static final String FILE_NAME = "SimpleFilePrinter";
    private static final String SLASH = System.getProperty("file.separator");
    private static final String FILE_PATH = ".";
    private static final Map<String, SimpleFileWriter> allFileWriters = new HashMap<String, SimpleFileWriter>();

    public SimpleFileWriter() throws Exception {
        this(FILE_PATH, "SimpleFilePrinter.txt");
    }

    public SimpleFileWriter(String fileName) throws Exception {
        this(FILE_PATH, fileName);
    }

    public SimpleFileWriter(String filePath, String fileName) throws Exception {
        File path = new File(filePath);
        path.mkdirs();
        if (!path.exists()) {
            throw new Exception("Path doesn't exist and couldn't be created");
        }
        File out = new File(filePath + SLASH + fileName);
        this.bw = new BufferedWriter(new FileWriter(out, false));
    }

    public synchronized void close() {
        try {
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void writeLine(String line) {
        try {
            this.bw.write(line);
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized SimpleFileWriter getInstance(String fileName) throws Exception {
        if (allFileWriters.get(FILE_PATH + SLASH + fileName) == null) {
            allFileWriters.put(FILE_PATH + SLASH + fileName, new SimpleFileWriter(fileName));
        }
        return allFileWriters.get(FILE_PATH + SLASH + fileName);
    }

    public static synchronized void removeInstance(String fileName) throws Exception {
        allFileWriters.remove(FILE_PATH + SLASH + fileName);
    }

    public static synchronized void writeTo(String fileName, String message) {
        try {
            SimpleFileWriter.getInstance(fileName).writeLine(message);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage() + " [" + message + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void close(String fileName) {
        try {
            SimpleFileWriter.getInstance(fileName).close();
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
        finally {
            try {
                SimpleFileWriter.removeInstance(fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        SimpleFileWriter.writeTo("test_out.txt", "Zeile 1");
        SimpleFileWriter.writeTo("test_out.txt", "Zeile 2");
        SimpleFileWriter.close("test_out.txt");
    }
}

