/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state.server;

import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.ExceptionResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.protocol.ProtocolException;
import bsc.sdk.kernel.transceiver.ChannelWorker;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.ATransceiverState;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import bsc.sdk.kernel.transceiver.state.StateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateWork
extends ATransceiverState {
    private static Logger logger = LoggerFactory.getLogger(StateWork.class);
    boolean inDisconnect = false;
    private Stage currentStage = Stage.HANDLE_INCOMING;

    public StateWork(StateConfiguration stateSettings) {
        super(stateSettings);
    }

    @Override
    public int getLevel() {
        return 2;
    }

    @Override
    public ITransceiverState execute() {
        switch (this.currentStage) {
            default: {
                return this;
            }
            case HANDLE_INCOMING: 
        }
        TransmissionObject transmissionObject = this.connector.getTransceiver().nextIncomingTransmission();
        if (transmissionObject != null && transmissionObject.getObject() != null) {
            long startTimestamp = System.currentTimeMillis();
            logger.trace("HANDLE_INCOMING " + transmissionObject.getID() + "->" + transmissionObject.getObject().getClass().getName());
            if (transmissionObject.getObject() instanceof Result) {
                this.connector.handle(transmissionObject);
                logger.trace("HANDLED after " + (System.currentTimeMillis() - startTimestamp) + " ms");
            } else {
                Result result = null;
                try {
                    result = transmissionObject.getObject() instanceof ProtocolException ? new ExceptionResult((ProtocolException)transmissionObject.getObject()) : this.connector.handle(transmissionObject);
                }
                catch (Exception e1) {
                    result = new ExceptionResult(e1);
                }
                logger.trace("HANDLED after " + (System.currentTimeMillis() - startTimestamp) + " ms");
                this.connector.getTransceiver().write(new TransmissionObject(transmissionObject.getID(), result), new ChannelWorker.WriteMode[0]);
                logger.trace("RESULT_SEND after " + (System.currentTimeMillis() - startTimestamp) + " ms for " + transmissionObject.getID() + "->" + transmissionObject.getObject().getClass().getName());
            }
        } else {
            logger.trace("HANDLE_INCOMING: NULL Object received!");
        }
        this.currentStage = Stage.HANDLE_INCOMING;
        return this;
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        if (!this.inDisconnect) {
            StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.ERROR, this.connector);
            stateSettings.setThrowable(exception);
            return StateFactory.getDefaultFactory().createState(stateSettings);
        }
        return null;
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        this.inDisconnect = true;
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, terminate ? StateFactory.STATE.TERMINATE : StateFactory.STATE.DISCONNECT, this.connector));
    }

    private static enum Stage {
        HANDLE_INCOMING,
        DONE;

    }
}

