/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state.client;

import bsc.api.transport.TransmissionObject;
import bsc.api.transport.commands.ConnectionRequest;
import bsc.api.transport.model.Caps;
import bsc.api.transport.result.ObjectResult;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.kernel.bus.messages.api.AddMetaInformations;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.transceiver.ChannelWorker;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.AStateInit;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import bsc.sdk.kernel.transceiver.state.StateFactory;

public class StateInit
extends AStateInit {
    private ISession session;
    private Stage currentStage = Stage.DONE;

    public StateInit(StateConfiguration stateSettings) {
        super(stateSettings);
        this.session = stateSettings.getSession();
        this.currentStage = Stage.CONTACTING_SERVER;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public ITransceiverState execute() {
        try {
            this.connector.getTransceiver().transceiverStateChanged(TransceiverState.STATE.INIT, this.currentStage.name());
            switch (this.currentStage) {
                default: {
                    return this;
                }
                case CONTACTING_SERVER: {
                    ConnectionRequest connectionRequest = new ConnectionRequest();
                    String vid = this.connector.getConnectionProfile().getVid();
                    if (vid != null) {
                        connectionRequest.addMetaInformation("M2M", "VID", vid);
                    }
                    if (this.session != null && this.session.getSessionID() != null) {
                        connectionRequest.setSessionID(this.session.getSessionID());
                    }
                    this.connector.getTransceiver().write(new TransmissionObject(this.getNewTransmissionId(), connectionRequest), false, ChannelWorker.WriteMode.JSON_PROTOCOL);
                    this.currentStage = Stage.CHECKING_FOR_SESSION;
                    this.connector.getTransceiver().getChannelHandler().start();
                    return this;
                }
                case CHECKING_FOR_SESSION: 
            }
            TransmissionObject transmissionObject = this.connector.getTransceiver().nextIncomingTransmission();
            Caps serverCaps = null;
            if (transmissionObject.getObject() instanceof Caps || transmissionObject.getObject() instanceof ObjectResult) {
                serverCaps = (Caps)this.checkResult(transmissionObject, Caps.class);
            }
            if (this.session != null && this.session.getSessionID() != null) {
                this.connector.getTransceiver().initialize(this.session.getSessionID());
                this.session.setLastUsedTimestamp(System.currentTimeMillis());
                this.connector.objectUpdated(this.session);
                System.out.println("CREATE State");
                return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.WORK, this.connector));
            }
            Caps caps = this.getCaps();
            this.connector.fireMessage(new AddMetaInformations(caps));
            this.connector.getTransceiver().write(new TransmissionObject(this.getNewTransmissionId(), caps), ChannelWorker.WriteMode.JSON_PROTOCOL);
            StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.AUTH, this.connector);
            stateSettings.setSession(this.session);
            stateSettings.setMetaInformations(serverCaps.getAllMetaInformations());
            return StateFactory.getDefaultFactory().createState(stateSettings);
        }
        catch (TransceiverException e) {
            System.out.println("ERRROR");
            return this.error(e);
        }
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.DISCONNECT, this.connector));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        StateConfiguration stateSettings = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.ERROR, this.connector);
        stateSettings.setThrowable(exception);
        return StateFactory.getDefaultFactory().createState(stateSettings);
    }

    private static enum Stage {
        CONTACTING_SERVER,
        CHECKING_FOR_SESSION,
        DONE;

    }
}

