/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver;

import bsc.sdk.api.transceiver.ReadPendingException;
import bsc.sdk.kernel.transceiver.CompletionHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BSCAsynchronousSocketChannel {
    private DataInputStream channelIn;
    private DataOutputStream channelOut;
    private boolean readPending = false;

    public BSCAsynchronousSocketChannel(DataInputStream channelIn, DataOutputStream channelOut) {
        this.channelIn = channelIn;
        this.channelOut = channelOut;
    }

    public void close() throws IOException {
        this.channelIn.close();
        this.channelOut.close();
    }

    public int write(ByteBuffer buffer) throws IOException {
        byte[] message = buffer.array();
        this.channelOut.write(message, 0, message.length);
        this.channelOut.flush();
        return message.length;
    }

    public void read(final ByteBuffer buffer, final ByteArrayOutputStream attachment, final CompletionHandler<Integer, ByteArrayOutputStream> handler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (BSCAsynchronousSocketChannel.this.readPending) {
                    throw new ReadPendingException();
                }
                BSCAsynchronousSocketChannel.this.readPending = true;
                try {
                    int bytesRead = 0;
                    byte[] input = new byte[buffer.remaining()];
                    if (input.length > 0) {
                        bytesRead = BSCAsynchronousSocketChannel.this.channelIn.read(input);
                        for (int i = 0; i < bytesRead; ++i) {
                            buffer.put(input[i]);
                        }
                    }
                    BSCAsynchronousSocketChannel.this.readPending = false;
                    handler.completed(new Integer(bytesRead), attachment);
                }
                catch (Throwable t) {
                    BSCAsynchronousSocketChannel.this.readPending = false;
                    handler.failed(t, attachment);
                }
            }
        }).start();
    }
}

