/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.user;

import bsc.sdk.api.user.session.ISession;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.module.user.GetSession;
import bsc.sdk.kernel.bus.messages.module.user.GetUserSessions;
import bsc.sdk.kernel.bus.messages.module.user.MarkSessionForRenewal;
import bsc.sdk.kernel.bus.messages.module.user.RequestNewSessionID;
import bsc.sdk.kernel.bus.messages.module.user.UpdateSession;
import bsc.sdk.kernel.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.kernel.executors.INamedRunnable;
import bsc.sdk.kernel.impl.BasicApiKernel;
import bsc.sdk.kernel.modules.idpool.IdPool;
import bsc.sdk.kernel.modules.idpool.IdPoolSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.listener.Handler;

public class SessionManager
extends BasicApiKernel.BasicKernelModule {
    protected HashMap<String, ISession> sessions;
    protected String persistenceFile = "sessions.bin";
    protected long sessionTimeout = 168L;
    protected TimeUnit sessionTimeoutTimeUnit = TimeUnit.HOURS;
    protected int maxSessions = 50000;
    protected long cleanupInterval = 1L;
    protected TimeUnit cleanupIntervalTimeUnit = TimeUnit.HOURS;
    protected final DynamicScheduledCachedThreadPoolExecutor.ScheduledTask scheduledTask;
    protected IdPool sessionIdPool = this.createNewPool(new IdPoolSettings("Session", IdPool.GENERATOR_TYPE.RANDOM_GUID, TimeUnit.DAYS.toMillis(8L), "", "", 0, "", 0));

    public SessionManager(AApplicationKernel kernel) {
        super(kernel);
        if (!this.load()) {
            this.sessions = new HashMap();
        }
        this.scheduledTask = this.backgroundScheduleAtFixedRate(new Executor(), 0L, this.cleanupInterval, this.cleanupIntervalTimeUnit);
    }

    @Override
    public void unload() {
        this.scheduledTask.cancel();
        this.save();
    }

    @Handler
    private void sessionUpdated(UpdateSession sessionUpdate) {
        this.sessionUpdated(sessionUpdate.getSession());
    }

    public synchronized void sessionUpdated(ISession session) {
        this.sessions.put(session.getSessionID(), session);
    }

    @Handler
    private void getSession(GetSession getSession) {
        getSession.setSession(this.getSession(getSession.getSessionID()));
    }

    public synchronized ISession getSession(String sessionID) {
        return this.sessions.get(sessionID);
    }

    @Handler
    private void getUserSessions(GetUserSessions getUserSessions) {
        getUserSessions.addSessions(this.getUserSessions(getUserSessions.getUserName()));
    }

    @Handler
    private void getNewSessionID(RequestNewSessionID request) {
        request.setSessionID(this.getNewSessionID());
    }

    public String getNewSessionID() {
        return this.sessionIdPool.getId();
    }

    public synchronized Collection<ISession> getUserSessions(String userName) {
        HashSet<ISession> result = new HashSet<ISession>();
        if (userName != null) {
            for (ISession session : this.sessions.values()) {
                if (!userName.equals(session.getUserCredentialID())) continue;
                result.add(session);
            }
        }
        return result;
    }

    public synchronized void cleanupSessions() {
        this.logger.trace("Cleanup sessions");
        Iterator<ISession> itr = this.sessions.values().iterator();
        while (itr.hasNext()) {
            ISession s = itr.next();
            long timeout = s.getTimestamp() + this.sessionTimeoutTimeUnit.toMillis(this.sessionTimeout);
            this.logger.trace("calculating timeout for session: " + s.getSessionID());
            if (timeout < System.currentTimeMillis()) {
                this.logger.trace("Session: " + s.getSessionID() + " has expired!");
                itr.remove();
                MarkSessionForRenewal message = new MarkSessionForRenewal(s);
                this.postKernelMessage(message).now();
                continue;
            }
            this.logger.trace("Session: " + s.getSessionID() + " is still valid.");
        }
        ArrayList<ISession> sessionsMax = new ArrayList<ISession>();
        sessionsMax.addAll(this.sessions.values());
        int difference = sessionsMax.size() - this.maxSessions;
        if (difference > 0) {
            this.logger.trace("Remove " + difference + " sessions because maxSessions is reached!");
            Collections.sort(sessionsMax);
            for (int i = 0; i < difference; ++i) {
                ISession session = (ISession)sessionsMax.get(i);
                this.sessions.remove(session.getSessionID());
                MarkSessionForRenewal message = new MarkSessionForRenewal(session);
                this.postKernelMessage(message).now();
            }
        }
    }

    public void save() {
        File file = new File(this.persistenceFile);
        try (FileOutputStream fout = new FileOutputStream(file);
             ObjectOutputStream oout = new ObjectOutputStream(fout);){
            oout.writeObject(this.sessions);
            oout.flush();
        }
        catch (Throwable e) {
            this.logger.error("Unable to save session file", e);
        }
    }

    public boolean load() {
        File file = new File(this.persistenceFile);
        if (file.exists()) {
            try (FileInputStream fin = new FileInputStream(file);
                 ObjectInputStream oin = new ObjectInputStream(fin);){
                this.sessions = (HashMap)oin.readObject();
            }
            catch (Exception e) {
                this.logger.error("Unable to load session file", (Throwable)e);
            }
        }
        return this.sessions != null;
    }

    @Override
    public void init() {
    }

    protected class Executor
    implements INamedRunnable {
        protected Executor() {
        }

        @Override
        public void run() {
            SessionManager.this.cleanupSessions();
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName() + "->Worker";
        }
    }
}

