/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.user;

import bsc.sdk.api.user.group.Permission;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.kernel.user.permission.AddPermission;
import bsc.sdk.kernel.bus.messages.kernel.user.permission.RemovePermission;
import bsc.sdk.kernel.bus.messages.module.user.permission.GetPermission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.engio.mbassy.listener.Handler;

public class PermissionManager
extends AApplicationKernel.KernelModule {
    protected final Map<String, ObjectPermissions> permissions = new HashMap<String, ObjectPermissions>();

    public PermissionManager(AApplicationKernel kernel) {
        super(kernel);
    }

    @Override
    public void unload() {
    }

    @Handler
    protected synchronized void addPermissions(AddPermission request) {
        if (!this.permissions.containsKey(request.getPermissionTypeID())) {
            this.permissions.put(request.getPermissionTypeID(), new ObjectPermissions(request.getPermissionTypeID()));
        }
        ObjectPermissions perm = this.permissions.get(request.getPermissionTypeID());
        perm.put(request.getObjectID(), request.getPermissions());
    }

    @Handler
    protected synchronized void removePermission(RemovePermission request) {
        ObjectPermissions perm = this.permissions.get(request.getPermissionTypeID());
        if (perm != null) {
            perm.remove(request.getObjectID());
            if (perm.isEmpty()) {
                this.permissions.remove(perm.getId());
            }
        }
    }

    @Handler
    protected synchronized void getPermission(GetPermission request) {
        EnumSet pSet;
        ObjectPermissions perm = this.permissions.get(request.getPermissionTypeID());
        if (perm != null && (pSet = (EnumSet)perm.get(request.getObjectID())) != null) {
            request.getPermissions().addAll(pSet);
        }
    }

    @Override
    public void init() {
    }

    protected class ObjectPermissions
    extends HashMap<String, EnumSet<Permission>> {
        private static final long serialVersionUID = -3646551356636559774L;
        private final String id;

        public ObjectPermissions(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum PERMISSION_TYPE {
        DEVICE;

    }
}

